/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.slimehud.util;

import java.text.NumberFormat;
import javax.annotation.Nonnull;

public final class HudBuilder {
    private static NumberFormat nf = NumberFormat.getInstance();

    @Nonnull
    public static String formatEnergyStored(int energy) {
        return "&7| " + HudBuilder.getAbbreviatedNumber(energy) + " J Stored";
    }

    @Nonnull
    public static String formatEnergyStored(int energy, int totalEnergy) {
        return "&7| " + HudBuilder.getAbbreviatedNumber(energy) + "/" + HudBuilder.getAbbreviatedNumber(totalEnergy) + " J";
    }

    @Nonnull
    public static String formatEnergyGenerated(int energy) {
        return "&7| &e\u26a1&7 " + HudBuilder.getAbbreviatedNumber(energy) + " J/t";
    }

    @Nonnull
    public static String getProgressBar(int progress, int total) {
        if (total == 0) {
            return "";
        }
        return HudBuilder.getProgressBar(100 * progress / total);
    }

    @Nonnull
    public static String getProgressBar(int percentCompleted) {
        percentCompleted = Math.min(Math.max(percentCompleted, 0), 100);
        StringBuffer progressBar = new StringBuffer();
        if (percentCompleted > 0) {
            int i;
            int color = 50;
            if (percentCompleted < 15) {
                color = 52;
            } else if (percentCompleted < 30) {
                color = 99;
            } else if (percentCompleted < 45) {
                color = 54;
            } else if (percentCompleted < 60) {
                color = 101;
            } else if (percentCompleted < 75) {
                color = 97;
            }
            int split = (percentCompleted + 4) / 10;
            progressBar.append("&").append((char)color);
            for (i = 0; i < split + 1; ++i) {
                progressBar.append("|");
            }
            progressBar.append("&7");
            for (i = 0; i < 10 - split; ++i) {
                progressBar.append("|");
            }
        } else {
            progressBar.append("|||||||||||");
        }
        return progressBar.toString();
    }

    @Nonnull
    public static String formatProgressBar(int progress, int total) {
        if (total == 0) {
            return "";
        }
        return HudBuilder.formatProgressBar(100 * progress / total);
    }

    @Nonnull
    public static String formatProgressBar(int percentCompleted) {
        return "&7| " + HudBuilder.getProgressBar(percentCompleted) + " - " + percentCompleted + "%";
    }

    @Nonnull
    public static String getAbbreviatedNumber(long n) {
        int i;
        String original = "" + n;
        int length = original.length() - (n < 0L ? 1 : 0);
        String append = "";
        if (length < 4) {
            return original;
        }
        if (length < 7) {
            append = "K";
        } else if (length < 10) {
            append = "M";
        } else if (length < 13) {
            append = "B";
        } else if (length < 16) {
            append = "T";
        } else if (length < 19) {
            append = "Qa";
        } else if (length < 22) {
            append = "Qi";
        }
        StringBuffer shortened = new StringBuffer();
        int leadingLength = (length - 1) % 3 + (n < 0L ? 2 : 1);
        for (i = 0; i < leadingLength; ++i) {
            shortened.append(original.charAt(i));
        }
        char dec1 = original.charAt(i);
        char dec2 = original.charAt(i + 1);
        boolean temp = dec2 != '0';
        if (temp || dec1 != '0') {
            shortened.append('.').append(dec1);
            if (temp) {
                shortened.append(dec2);
            }
        }
        return shortened.append(append).toString();
    }

    @Nonnull
    public static String getCommaNumber(long n) {
        return nf.format(n);
    }

    private HudBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

