/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.slimecustomizer.registration;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.LockedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.NestedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SeasonalItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.SubItemGroup;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.ncbpfluffybear.slimecustomizer.Registry;
import io.ncbpfluffybear.slimecustomizer.SlimeCustomizer;
import io.ncbpfluffybear.slimecustomizer.Utils;
import java.time.DateTimeException;
import java.time.Month;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Categories {
    public static boolean register(Config categories) {
        if (categories.getKeys().isEmpty()) {
            Utils.disable("No categories were found! Please add and use a category from categories.yml");
            return false;
        }
        for (String categoryKey : categories.getKeys()) {
            NestedItemGroup tempCategory;
            int tier;
            String itemGroupKey = categoryKey.toLowerCase(Locale.ROOT);
            String type = categories.getString(categoryKey + ".type");
            String name = categories.getString(categoryKey + ".category-name");
            String materialString = categories.getString(categoryKey + ".category-item");
            String tierStr = categories.getString(categoryKey + ".tier");
            Material material = Material.getMaterial((String)materialString);
            ItemStack item = null;
            if (type == null) {
                type = "normal";
                categories.setValue(categoryKey + ".type", (Object)type);
                categories.save();
            }
            if (material == null && !materialString.startsWith("SKULL")) {
                Utils.disable("The category-item for " + categoryKey + " is invalid!");
                return false;
            }
            if (material != null) {
                item = new ItemStack(material);
            } else if (materialString.startsWith("SKULL")) {
                item = SlimefunUtils.getCustomHead((String)materialString.replace("SKULL", "").toLowerCase());
            }
            item = new CustomItemStack(item, name, new String[0]);
            if (Registry.allItemGroups.containsKey(itemGroupKey)) {
                Utils.disable("The category " + categoryKey + " has already been registered!");
                return false;
            }
            NamespacedKey key = new NamespacedKey((Plugin)SlimeCustomizer.getInstance(), itemGroupKey);
            try {
                tier = Integer.parseInt(tierStr);
            }
            catch (NumberFormatException ex) {
                tier = 3;
            }
            if (type.equalsIgnoreCase("nested")) {
                tempCategory = new NestedItemGroup(key, item, tier);
            } else if (type.equalsIgnoreCase("sub")) {
                String parent = categories.getString(categoryKey + ".parent");
                if (parent == null) {
                    Utils.disable("The category " + categoryKey + " has invalid parent group!");
                    return false;
                }
                ItemGroup parentGroup = Registry.allItemGroups.get(parent);
                if (!(parentGroup instanceof NestedItemGroup)) {
                    Utils.disable("The category " + categoryKey + " has invalid parent group!");
                    return false;
                }
                tempCategory = new SubItemGroup(key, (NestedItemGroup)parentGroup, item, tier);
            } else if (type.equalsIgnoreCase("seasonal")) {
                Month month;
                int monthNum = categories.getInt(categoryKey + ".month");
                try {
                    month = Month.of(monthNum);
                }
                catch (DateTimeException ex) {
                    Utils.disable("The category " + categoryKey + " has invalid month!");
                    return false;
                }
                tempCategory = new SeasonalItemGroup(key, month, tier, item);
            } else if (type.equalsIgnoreCase("locked")) {
                List parents = categories.getStringList(categoryKey + ".parents");
                NamespacedKey[] parentKeys = new NamespacedKey[parents.size()];
                int i = 0;
                for (String parent : parents) {
                    parentKeys[i++] = NamespacedKey.fromString((String)parent, (Plugin)SlimeCustomizer.getInstance());
                }
                tempCategory = new LockedItemGroup(key, item, tier, parentKeys);
            } else {
                type = "normal";
                tempCategory = new ItemGroup(key, item, tier);
            }
            Registry.allItemGroups.put(categoryKey, (ItemGroup)tempCategory);
            Utils.notify("Category " + categoryKey + " (" + type + ") has been registered!");
        }
        return true;
    }
}

