/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.slimecustomizer.objects;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideHistory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.guide.SurvivalSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SCMenu
extends ChestMenu {
    private static final int BACK_BUTTON_SLOT = 0;

    public SCMenu(String title) {
        super(title);
    }

    public void addBackButton(SurvivalSlimefunGuide guide, Player p, PlayerProfile profile) {
        GuideHistory history = profile.getGuideHistory();
        if (history.size() > 1) {
            this.replaceExistingItem(0, (ItemStack)new CustomItemStack(ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", "&fLeft Click: &7Go back to previous Page", "&fShift + left Click: &7Go back to Main Menu"})));
            this.addMenuClickHandler(0, (pl, s, ic, action) -> {
                if (!action.isRightClicked() && action.isShiftClicked()) {
                    guide.openMainMenu(profile, 1);
                } else {
                    history.openLastEntry((SlimefunGuideImplementation)guide);
                }
                return false;
            });
        } else {
            this.replaceExistingItem(0, (ItemStack)new CustomItemStack(ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", ChatColor.GRAY + Slimefun.getLocalization().getMessage(p, "guide.back.guide")})));
            this.addMenuClickHandler(0, (pl, s, is, action) -> {
                guide.openMainMenu(profile, 1);
                return false;
            });
        }
    }

    public void setBackgroundNonClickable(boolean addBackground) {
        for (int i = 0; i < this.toInventory().getSize(); ++i) {
            if (!this.hasClickHandler(i)) {
                this.addMenuClickHandler(i, (pl, s, is, action) -> false);
            }
            if (!addBackground || this.getItemInSlot(i) != null) continue;
            this.replaceExistingItem(i, ChestMenuUtils.getBackground());
        }
    }

    public void wipe(int start, int finish, boolean blockClicks) {
        for (int i = start; i <= finish; ++i) {
            this.replaceExistingItem(i, null);
            if (!blockClicks) continue;
            this.addMenuClickHandler(i, (pl, s, is, action) -> false);
        }
    }

    public ItemStack pushItem(ItemStack item, int ... slots) {
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("Cannot push null or AIR");
        }
        ItemStackWrapper wrapper = null;
        int amount = item.getAmount();
        for (int slot : slots) {
            if (amount <= 0) break;
            ItemStack stack = this.getItemInSlot(slot);
            if (stack == null) {
                this.replaceExistingItem(slot, item);
                return null;
            }
            int maxStackSize = Math.min(stack.getMaxStackSize(), this.toInventory().getMaxStackSize());
            if (stack.getAmount() >= maxStackSize) continue;
            if (wrapper == null) {
                wrapper = ItemStackWrapper.wrap((ItemStack)item);
            }
            if (!ItemUtils.canStack((ItemStack)wrapper, (ItemStack)stack)) continue;
            stack.setAmount(Math.min(stack.getAmount() + item.getAmount(), maxStackSize));
            item.setAmount(amount -= maxStackSize - stack.getAmount());
        }
        if (amount > 0) {
            return new CustomItemStack(item, amount);
        }
        return null;
    }

    public boolean hasClickHandler(int slot) {
        return this.getMenuClickHandler(slot) != null;
    }

    public void setSize(int size) {
        this.addItem(size - 1, null);
    }
}

