/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.slimecustomizer.objects;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.ncbpfluffybear.slimecustomizer.Utils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class CustomMachine
extends AContainer
implements RecipeDisplayItem {
    public static final ItemStack MULTI_INPUT_ITEM = new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&aMultiple Inputs", new String[]{"", "&7> Click to view the items"});
    public static final ItemStack MULTI_OUTPUT_ITEM = new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&aMultiple Outputs", new String[]{"", "&7> Click to view the items"});
    private final String id;
    private final ItemStack progressItem;
    private final int energyConsumption;
    private final int energyBuffer;
    private final LinkedHashMap<Pair<ItemStack[], ItemStack[]>, Integer> customRecipes;

    public CustomMachine(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, String id, Material progressItem, int energyConsumption, int energyBuffer, LinkedHashMap<Pair<ItemStack[], ItemStack[]>, Integer> customRecipes) {
        super(category, item, recipeType, recipe);
        this.id = id;
        this.progressItem = new ItemStack(progressItem);
        this.energyConsumption = energyConsumption;
        this.energyBuffer = energyBuffer;
        this.customRecipes = customRecipes;
        this.getMachineProcessor().setProgressBar(this.getProgressBar());
    }

    public ItemStack getProgressBar() {
        return this.progressItem;
    }

    public int getCapacity() {
        return this.energyBuffer;
    }

    public int getEnergyConsumption() {
        return this.energyConsumption;
    }

    public int getSpeed() {
        return 1;
    }

    protected void registerDefaultRecipes() {
        if (this.customRecipes == null) {
            return;
        }
        this.customRecipes.forEach((recipe, time) -> this.registerRecipe((int)time, (ItemStack[])((ItemStack[])recipe.getFirstValue()).clone(), (ItemStack[])((ItemStack[])recipe.getSecondValue()).clone()));
    }

    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>(this.recipes.size() * 2);
        for (int i = 0; i < this.recipes.size(); ++i) {
            MachineRecipe recipe = (MachineRecipe)this.recipes.get(i);
            if (recipe.getInput().length == 2) {
                displayRecipes.add(Utils.keyItem(MULTI_INPUT_ITEM.clone(), i));
            } else {
                displayRecipes.add(recipe.getInput()[0]);
            }
            if (recipe.getOutput().length == 2) {
                displayRecipes.add(Utils.keyItem(MULTI_OUTPUT_ITEM.clone(), i));
                continue;
            }
            displayRecipes.add(recipe.getOutput()[0]);
        }
        return displayRecipes;
    }

    public String getMachineIdentifier() {
        return this.id;
    }
}

