/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.slimecustomizer.objects;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.ncbpfluffybear.slimecustomizer.Utils;
import io.ncbpfluffybear.slimecustomizer.extrautils.utils.LoreBuilderDynamic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SCMachine {
    private final Config config;
    private final String key;
    private boolean valid = true;
    private final String materialString;
    private final Material progressItem;
    private final String machineType;
    private ItemStack block;
    private int energyConsumption = 0;
    private int energyProduction = 0;
    private int energyBuffer = 0;
    private final ItemStack[] recipe;
    private final RecipeType recipeType;
    private SlimefunItemStack machineStack;

    public SCMachine(Config config, String key, String machineType) {
        this.config = config;
        this.key = key;
        this.materialString = config.getString(key + ".block-type").toUpperCase();
        this.progressItem = Material.getMaterial((String)config.getString(key + ".progress-bar-item").toUpperCase());
        this.machineType = machineType;
        this.validateMachineSettings();
        Utils.updateCraftingRecipeFormat(config, key);
        Utils.updateCategoryFormat(config, key);
        this.recipeType = Utils.getRecipeType(config.getString(key + ".crafting-recipe-type"), key);
        if (this.recipeType == null) {
            this.valid = false;
        }
        this.recipe = Utils.buildCraftingRecipe(config, key, this.recipeType);
        if (this.recipe == null) {
            this.valid = false;
        }
        this.buildMachineStack();
    }

    private void validateMachineSettings() {
        Material material = Material.getMaterial((String)this.materialString);
        if (!(material != null && material.isBlock() || this.materialString.startsWith("SKULL"))) {
            Utils.disable("The block-type for " + this.key + " MUST be a block!");
        } else if (material != null && material.isBlock()) {
            this.block = new ItemStack(material);
        } else if (this.materialString.startsWith("SKULL")) {
            this.block = SlimefunUtils.getCustomHead((String)this.materialString.replace("SKULL", "").toLowerCase());
        }
        if (this.progressItem == null) {
            Utils.disable("The progress-bar-item for " + this.key + " is not a valid vanilla ID!");
        }
        if (this.machineType.equalsIgnoreCase("machine")) {
            try {
                this.energyConsumption = Integer.parseInt(this.config.getString(this.key + ".stats.energy-consumption"));
                this.energyBuffer = Integer.parseInt(this.config.getString(this.key + ".stats.energy-buffer"));
            }
            catch (NumberFormatException e) {
                Utils.disable("The energy-consumption and energy-buffer for " + this.key + " must be a positive integer!");
            }
            if (this.energyConsumption < 0 || this.energyBuffer < 0) {
                Utils.disable("The energy-consumption and energy-buffer for " + this.key + " must be a positive integer!");
            }
        } else if (this.machineType.equalsIgnoreCase("generator")) {
            try {
                this.energyProduction = Integer.parseInt(this.config.getString(this.key + ".stats.energy-production"));
                this.energyBuffer = Integer.parseInt(this.config.getString(this.key + ".stats.energy-buffer"));
            }
            catch (NumberFormatException e) {
                Utils.disable("The energy-consumption and energy-buffer for " + this.key + " must be a positive integer!");
            }
            if (this.energyProduction < 0 || this.energyBuffer < 0) {
                Utils.disable("The energy-production and energy-buffer for " + this.key + " must be a positive integer!");
            }
        }
    }

    private void buildMachineStack() {
        Utils.updateLoreFormat(this.config, this.key, this.machineType);
        List<String> itemLore = Utils.colorList(Stream.concat(this.config.getStringList(this.key + "." + this.machineType + "-lore").stream(), new ArrayList<String>(Arrays.asList("", this.getMachineTag(), LoreBuilderDynamic.powerBuffer(this.energyBuffer), LoreBuilderDynamic.powerPerTick(this.getEnergyExchange()))).stream()).collect(Collectors.toList()));
        this.machineStack = new SlimefunItemStack(this.key, this.block, this.config.getString(this.key + "." + this.machineType + "-name"), new String[0]);
        ItemMeta tempMeta = this.machineStack.getItemMeta();
        tempMeta.setLore(itemLore);
        this.machineStack.setItemMeta(tempMeta);
    }

    private String getMachineTag() {
        if (this.machineType.equalsIgnoreCase("machine")) {
            return "&b" + Utils.capitalize(this.machineType);
        }
        if (this.machineType.equalsIgnoreCase("generator")) {
            return "&a" + Utils.capitalize(this.machineType);
        }
        return null;
    }

    private int getEnergyExchange() {
        if (this.machineType.equalsIgnoreCase("machine")) {
            return this.energyConsumption;
        }
        if (this.machineType.equalsIgnoreCase("generator")) {
            return this.energyProduction;
        }
        return 0;
    }

    public Material getProgressItem() {
        return this.progressItem;
    }

    public int getEnergyProduction() {
        return this.energyProduction;
    }

    public int getEnergyConsumption() {
        return this.energyConsumption;
    }

    public int getEnergyBuffer() {
        return this.energyBuffer;
    }

    public ItemStack[] getRecipe() {
        return this.recipe;
    }

    public SlimefunItemStack getMachineStack() {
        return this.machineStack;
    }

    public RecipeType getRecipeType() {
        return this.recipeType;
    }

    public boolean isValid() {
        return this.valid;
    }
}

