/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.slimecustomizer.objects;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.AbstractEnergyProvider;
import io.github.thebusybiscuit.slimefun4.implementation.operations.FuelOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.HashMap;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class SCAGenerator
extends AbstractEnergyProvider
implements MachineProcessHolder<FuelOperation> {
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] border_in = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private static final int[] border_out = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};
    private final MachineProcessor<FuelOperation> processor = new MachineProcessor((MachineProcessHolder)this);
    private int energyProducedPerTick = -1;
    private int energyCapacity = -1;

    protected SCAGenerator(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.processor.setProgressBar(this.getProgressBar());
        new BlockMenuPreset(item.getItemId(), this.getInventoryTitle()){

            public void init() {
                SCAGenerator.this.constructMenu(this);
            }

            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return SCAGenerator.this.getInputSlots();
                }
                return SCAGenerator.this.getOutputSlots();
            }
        };
        this.addItemHandler(new ItemHandler[]{this.onBlockBreak()});
        this.registerDefaultFuelTypes();
    }

    public MachineProcessor<FuelOperation> getMachineProcessor() {
        return this.processor;
    }

    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            public void onBlockBreak(Block b) {
                BlockMenu inv = BlockStorage.getInventory((Block)b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), SCAGenerator.this.getInputSlots());
                    inv.dropItems(b.getLocation(), SCAGenerator.this.getOutputSlots());
                }
                SCAGenerator.this.processor.endOperation(b);
            }
        };
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_in) {
            preset.addItem(i, ChestMenuUtils.getInputSlotTexture(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_out) {
            preset.addItem(i, ChestMenuUtils.getOutputSlotTexture(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    if (cursor == null) {
                        return true;
                    }
                    cursor.getType();
                    return cursor.getType() == Material.AIR;
                }
            });
        }
        preset.addItem(22, (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
    }

    public int[] getInputSlots() {
        return new int[]{19, 20};
    }

    public int[] getOutputSlots() {
        return new int[]{24, 25};
    }

    public int getGeneratedOutput(Location l, Config data) {
        BlockMenu inv = BlockStorage.getInventory((Location)l);
        FuelOperation operation = (FuelOperation)this.processor.getOperation(l);
        if (operation != null) {
            if (!operation.isFinished()) {
                this.processor.updateProgressBar(inv, 22, (MachineOperation)operation);
                if (this.isChargeable()) {
                    int charge = this.getCharge(l, data);
                    if (this.getCapacity() - charge >= this.getEnergyProduction()) {
                        operation.addProgress(1);
                        return this.getEnergyProduction();
                    }
                    return 0;
                }
                operation.addProgress(1);
                return this.getEnergyProduction();
            }
            ItemStack fuel = operation.getIngredient();
            if (this.isBucket(fuel)) {
                inv.pushItem(new ItemStack(Material.BUCKET), this.getOutputSlots());
            }
            if (operation.getResult() != null) {
                inv.pushItem(operation.getResult().clone(), this.getOutputSlots());
            }
            inv.replaceExistingItem(22, (ItemStack)new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
            this.processor.endOperation(l);
            return 0;
        }
        HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
        MachineFuel fuel = this.findRecipe(inv, found);
        if (fuel != null) {
            for (Map.Entry entry : found.entrySet()) {
                inv.consumeItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
            }
            this.processor.startOperation(l, (MachineOperation)new FuelOperation(fuel));
        }
        return 0;
    }

    private boolean isBucket(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemStackWrapper wrapper = ItemStackWrapper.wrap((ItemStack)item);
        return item.getType() == Material.LAVA_BUCKET || SlimefunUtils.isItemSimilar((ItemStack)wrapper, (ItemStack)SlimefunItems.FUEL_BUCKET, (boolean)true) || SlimefunUtils.isItemSimilar((ItemStack)wrapper, (ItemStack)SlimefunItems.OIL_BUCKET, (boolean)true);
    }

    private MachineFuel findRecipe(BlockMenu menu, Map<Integer, Integer> found) {
        for (MachineFuel fuel : this.fuelTypes) {
            for (int slot : this.getInputSlots()) {
                if (!fuel.test(menu.getItemInSlot(slot))) continue;
                found.put(slot, fuel.getInput().getAmount());
                return fuel;
            }
        }
        return null;
    }

    public int getCapacity() {
        return this.energyCapacity;
    }

    public int getEnergyProduction() {
        return this.energyProducedPerTick;
    }

    public final SCAGenerator setCapacity(int capacity) {
        Validate.isTrue((capacity >= 0 ? 1 : 0) != 0, (String)"The capacity cannot be negative!");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    public final SCAGenerator setEnergyProduction(int energyProduced) {
        Validate.isTrue((energyProduced > 0 ? 1 : 0) != 0, (String)"The energy production must be greater than zero!");
        this.energyProducedPerTick = energyProduced;
        return this;
    }

    public void register(SlimefunAddon addon) {
        this.addon = addon;
        if (this.getCapacity() < 0) {
            this.warn("The capacity has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + ((Object)((Object)this)).getClass().getSimpleName() + "#setEnergyCapacity(...)' before registering!");
        }
        if (this.getEnergyProduction() <= 0) {
            this.warn("The energy consumption has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + ((Object)((Object)this)).getClass().getSimpleName() + "#setEnergyProduction(...)' before registering!");
        }
        if (this.getCapacity() >= 0 && this.getEnergyProduction() > 0) {
            super.register(addon);
        }
    }
}

