/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.slimecustomizer;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.NestedItemGroup;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.ncbpfluffybear.slimecustomizer.Registry;
import io.ncbpfluffybear.slimecustomizer.SlimeCustomizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Utils {
    private static final NamespacedKey SCKEY = new NamespacedKey((Plugin)SlimeCustomizer.getInstance(), "slimecustomizer_item");
    private static final List<RecipeType> STACK_LIMITED_MACHINES = new ArrayList<RecipeType>(Arrays.asList(RecipeType.ENHANCED_CRAFTING_TABLE, RecipeType.ARMOR_FORGE, RecipeType.PRESSURE_CHAMBER, RecipeType.MAGIC_WORKBENCH));

    public static void send(CommandSender s, String msg) {
        s.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&a&l[&aSlimeCustomizer&a&l]&7 " + msg)));
    }

    public static boolean checkPermission(Player p, String permission) {
        if (!p.hasPermission(permission)) {
            Utils.send((CommandSender)p, "&cYou do not have permission to use this command!");
            return false;
        }
        return true;
    }

    public static String color(String str) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)str);
    }

    public static void notify(String reason) {
        Bukkit.getConsoleSender().sendMessage("[SlimeCustomizer] " + ChatColor.GREEN + reason);
    }

    public static void disable(String reason) {
        Bukkit.getLogger().log(Level.SEVERE, "[SlimeCustomizer] " + reason);
        Bukkit.getPluginManager().disablePlugin((Plugin)SlimeCustomizer.getInstance());
    }

    public static boolean checkFitsStackSize(ItemStack item, String slot, String machineKey, String recipeKey) {
        if (item.getAmount() > item.getMaxStackSize()) {
            Utils.disable("The " + slot + "ingredient for recipe" + recipeKey + " for " + machineKey + " has a max stack size of " + item.getMaxStackSize() + "!");
            return false;
        }
        return true;
    }

    public static List<String> colorList(List<String> plainList) {
        ArrayList<String> coloredList = new ArrayList<String>();
        for (String s : plainList) {
            coloredList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return coloredList;
    }

    public static ItemStack[] buildCraftingRecipe(Config file, String key, RecipeType recipeType) {
        ItemStack[] recipe = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            int amount;
            String path = key + ".crafting-recipe";
            int configIndex = i + 1;
            String type = file.getString(path + "." + configIndex + ".type").toUpperCase();
            String material = file.getString(path + "." + configIndex + ".id").toUpperCase();
            try {
                amount = Integer.parseInt(file.getString(path + "." + configIndex + ".amount"));
            }
            catch (NumberFormatException e) {
                Utils.disable("Crafting recipe item " + configIndex + " for " + key + " must be a positive integer!");
                return null;
            }
            if (STACK_LIMITED_MACHINES.contains(recipeType) && amount > 1) {
                Utils.disable(recipeType.getKey().getKey().toUpperCase() + " can not use items with a greater stack size than 1! Please change the crafting-recipe-type or crafting-recipe.#.amount for " + key + ".");
                return null;
            }
            if (type.equalsIgnoreCase("NONE")) {
                recipe[i] = null;
                continue;
            }
            if (type.equalsIgnoreCase("VANILLA")) {
                Material vanillaMat = Material.getMaterial((String)material);
                if (vanillaMat == null) {
                    Utils.disable("Crafting ingredient " + configIndex + " for " + key + " is not a valid vanilla ID!");
                    return null;
                }
                recipe[i] = new ItemStack(vanillaMat, amount);
                continue;
            }
            if (type.equalsIgnoreCase("SLIMEFUN")) {
                SlimefunItem sfMat = SlimefunItem.getById((String)material);
                if (sfMat == null) {
                    Utils.disable("Crafting ingredient " + configIndex + " for " + key + " is not a valid Slimefun ID!");
                    return null;
                }
                recipe[i] = new CustomItemStack(sfMat.getItem().clone(), amount);
                continue;
            }
            if (type.equalsIgnoreCase("SAVEDITEM")) {
                recipe[i] = Utils.retrieveSavedItem(material, amount, true);
                continue;
            }
            Utils.disable("Crafting ingredient " + configIndex + " for " + key + " can only have a type of VANILLA, SLIMEFUN, SAVEDITEM, or NONE!");
            return null;
        }
        AtomicBoolean invalid = new AtomicBoolean(false);
        Registry.existingRecipes.forEach((itemStacks, recipeTypePair) -> {
            if (Arrays.equals(itemStacks, recipe) && recipeType == recipeTypePair.getFirstValue()) {
                Utils.disable("The crafting recipe for " + key + " is already being used for " + (String)recipeTypePair.getSecondValue());
                invalid.set(true);
            }
        });
        if (invalid.get()) {
            return null;
        }
        if (recipeType != RecipeType.NULL) {
            Registry.existingRecipes.put(recipe, (Pair<RecipeType, String>)new Pair((Object)recipeType, (Object)key));
        }
        return recipe;
    }

    public static ItemStack getBlockFromConfig(String key, String materialString) {
        if (materialString == null) {
            Utils.disable("The material for " + key + " could not be found!");
            return null;
        }
        ItemStack block = null;
        Material material = Material.getMaterial((String)materialString);
        if (!(material != null && material.isBlock() || materialString.startsWith("SKULL"))) {
            Utils.disable("The block-type for " + key + " MUST be a block!");
            return null;
        }
        if (material != null && material.isBlock()) {
            block = new ItemStack(material);
        } else if (materialString.startsWith("SKULL")) {
            block = SlimefunUtils.getCustomHead((String)materialString.replace("SKULL", "").toLowerCase());
        }
        return block;
    }

    public static void updateLoreFormat(Config config, String key, String machineType) {
        String path = key + "." + machineType + "-lore";
        if (config.getStringList(path).toString().equals("[]")) {
            Bukkit.getLogger().log(Level.WARNING, "Your " + key + " was reformatted to use the new lore system!Read " + "https://github.com/NCBPFluffyBear/SlimeCustomizer#adding-your-item" + " to learn how to use multiline lore!");
            String lore = config.getString(path);
            config.setValue(path, new ArrayList<String>(Collections.singleton(lore)));
            config.save();
        }
    }

    public static void updateCraftingRecipeFormat(Config config, String key) {
        String path = key + ".crafting-recipe";
        for (int i = 0; i < 9; ++i) {
            int recipeIndex = i + 1;
            if (config.getString(path + "." + recipeIndex + ".amount") != null) continue;
            config.setValue(path + "." + recipeIndex + ".amount", (Object)1);
        }
        if (config.getString(key + ".crafting-recipe-type") == null) {
            config.setValue(key + ".crafting-recipe-type", (Object)"ENHANCED_CRAFTING_TABLE");
        }
        config.save();
    }

    public static void updateCategoryFormat(Config config, String key) {
        String path = key + ".category";
        if (config.getString(path) == null) {
            config.setValue(path, (Object)"slime_customizer");
        }
        config.save();
    }

    public static void updateInputAndOutputFormat(Config config, String key) {
        String path = key + ".recipes";
        for (String recipe : config.getKeys(path)) {
            for (int i = 0; i < 2; ++i) {
                String transportType = i == 0 ? "input" : "output";
                String transportPath = path + "." + recipe + "." + transportType;
                if (config.getString(transportPath + ".1") != null) continue;
                config.setValue(transportPath + ".1.type", (Object)config.getString(transportPath + ".type"));
                config.setValue(transportPath + ".1.id", (Object)config.getString(transportPath + ".id"));
                config.setValue(transportPath + ".1.amount", (Object)config.getInt(transportPath + ".amount"));
                config.setValue(transportPath + ".type", null);
                config.setValue(transportPath + ".id", null);
                config.setValue(transportPath + ".amount", null);
                config.setValue(transportPath + ".2.type", (Object)"NONE");
                config.setValue(transportPath + ".2.id", (Object)"N/A");
                config.setValue(transportPath + ".2.amount", (Object)1);
                Bukkit.getLogger().log(Level.WARNING, "Your " + key + " was reformatted to use the new input/output system! Read " + "https://github.com/NCBPFluffyBear/SlimeCustomizer#adding-your-machine" + " to learn what this new format does!");
            }
        }
        config.save();
    }

    public static void updatePlaceableOption(Config config, String key) {
        if (config.getValue(key + ".placeable") != null) {
            return;
        }
        config.setValue(key + ".placeable", (Object)false);
        Bukkit.getLogger().log(Level.WARNING, "Your " + key + " was reformatted to have a placeable option! Read " + "https://github.com/NCBPFluffyBear/SlimeCustomizer#adding-your-item" + " to learn what this new option does!");
        Bukkit.getLogger().log(Level.SEVERE, "This option is false by default, so if you have a block you need to be placeable, change this immediately!");
        config.save();
    }

    public static ItemStack retrieveSavedItem(String id, int amount, boolean disableIfNull) {
        File serializedItemFile = new File(SlimeCustomizer.getInstance().getDataFolder(), "saveditems/" + id + ".yml");
        if (!serializedItemFile.exists()) {
            if (disableIfNull) {
                Utils.disable(id + " could not be found in your saveditems folder! Make sure the file is a yml file!");
            }
            return null;
        }
        ItemStack item = new Config(serializedItemFile.getPath()).getItem("item");
        item.setAmount(amount);
        return item;
    }

    public static RecipeType getRecipeType(String str, String key) {
        if (str == null) {
            Utils.disable("The crafting-recipe-type for " + key + " has to be a multiblock machine!");
            return null;
        }
        switch (str) {
            default: {
                return null;
            }
            case "ENCHANTED_CRAFTING_TABLE": {
                Bukkit.getLogger().log(Level.WARNING, "Hey buddy, it's the ENHANCED crafting table, not ENCHANTED. Don't worry, I know what you mean. But you should probably fix that.");
                return RecipeType.ENHANCED_CRAFTING_TABLE;
            }
            case "ENHANCED_CRAFTING_TABLE": {
                return RecipeType.ENHANCED_CRAFTING_TABLE;
            }
            case "MAGIC_WORKBENCH": {
                return RecipeType.MAGIC_WORKBENCH;
            }
            case "ARMOR_FORGE": {
                return RecipeType.ARMOR_FORGE;
            }
            case "COMPRESSOR": {
                return RecipeType.COMPRESSOR;
            }
            case "PRESSURE_CHAMBER": {
                return RecipeType.PRESSURE_CHAMBER;
            }
            case "SMELTERY": {
                return RecipeType.SMELTERY;
            }
            case "ORE_CRUSHER": {
                return RecipeType.ORE_CRUSHER;
            }
            case "GRIND_STONE": {
                return RecipeType.GRIND_STONE;
            }
            case "NONE": 
        }
        return RecipeType.NULL;
    }

    public static ItemGroup getCategory(String str, String key) {
        if (str.startsWith("existing:")) {
            String[] existingCat = str.substring(9).split(":");
            if (existingCat.length != 2) {
                Utils.disable("The category for " + key + " has a format issue. Ex: existing:slimefun:misc");
                return null;
            }
            for (ItemGroup itemGroup : Slimefun.getRegistry().getAllItemGroups()) {
                if (!itemGroup.getKey().getNamespace().equals(existingCat[0]) || !itemGroup.getKey().getKey().equals(existingCat[1])) continue;
                return itemGroup;
            }
            Utils.disable(existingCat[0] + ":" + existingCat[1] + " is not a valid existing category for " + key + "!");
            return null;
        }
        ItemGroup category = Registry.allItemGroups.get(str);
        if (category == null || category instanceof NestedItemGroup) {
            Utils.disable(str + " is not a valid category for " + key + "!");
        }
        return category;
    }

    public static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    public static String toOrdinal(int i) {
        switch (i) {
            default: {
                return "ERR";
            }
            case 1: {
                return "1st";
            }
            case 2: 
        }
        return "2nd";
    }

    public static ItemStack keyItem(ItemStack item, int i) {
        ItemMeta meta = item.getItemMeta();
        meta.getPersistentDataContainer().set(SCKEY, PersistentDataType.INTEGER, (Object)i);
        item.setItemMeta(meta);
        return item;
    }

    public static boolean isKeyed(ItemStack item) {
        return item.getItemMeta().getPersistentDataContainer().has(SCKEY, PersistentDataType.INTEGER);
    }

    public static int getItemKey(ItemStack item) {
        return (Integer)item.getItemMeta().getPersistentDataContainer().get(SCKEY, PersistentDataType.INTEGER);
    }
}

