/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.slimecustomizer.registration;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.ncbpfluffybear.slimecustomizer.SlimeCustomizer;
import io.ncbpfluffybear.slimecustomizer.Utils;
import io.ncbpfluffybear.slimecustomizer.objects.CustomGenerator;
import io.ncbpfluffybear.slimecustomizer.objects.SCMachine;
import java.util.ArrayList;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class Generators {
    public static boolean register(Config generators) {
        for (String generatorKey : generators.getKeys()) {
            SCMachine generator;
            if (generatorKey.equals("EXAMPLE_GENERATOR")) {
                SlimeCustomizer.getInstance().getLogger().log(Level.WARNING, "Your generators.yml file still contains the example generator! Did you forget to set up the plugin?");
            }
            if (!(generator = new SCMachine(generators, generatorKey, "generator")).isValid()) {
                return false;
            }
            ItemGroup category = Utils.getCategory(generators.getString(generatorKey + ".category"), generatorKey);
            if (category == null) {
                return false;
            }
            ArrayList<MachineFuel> customRecipe = new ArrayList<MachineFuel>();
            for (String recipeKey : generators.getKeys(generatorKey + ".recipes")) {
                int time;
                String path = generatorKey + ".recipes." + recipeKey;
                ItemStack input = null;
                ItemStack output = null;
                try {
                    time = Integer.parseInt(generators.getString(path + ".time-in-seconds"));
                }
                catch (NumberFormatException e) {
                    Utils.disable("The time-in-seconds for recipe " + recipeKey + " for " + generatorKey + " must be a positive integer!");
                    return false;
                }
                if (time < 0) {
                    Utils.disable("The time-in-seconds for recipe " + recipeKey + " for " + generatorKey + " must be a positive integer!");
                    return false;
                }
                for (int i = 0; i < 2; ++i) {
                    String slot = i == 0 ? "input" : "output";
                    String type = generators.getString(path + "." + slot + ".type").toUpperCase();
                    String material = generators.getString(path + "." + slot + ".id").toUpperCase();
                    int amount = 0;
                    if (i == 0 && type.equalsIgnoreCase("NONE")) {
                        Utils.disable("The the input type for recipe " + recipeKey + " for " + generatorKey + " can only be VANILLA or SLIMEFUN!");
                        return false;
                    }
                    if (i == 0 || !type.equalsIgnoreCase("NONE")) {
                        try {
                            amount = Integer.parseInt(generators.getString(path + "." + slot + ".amount"));
                        }
                        catch (NumberFormatException e) {
                            Utils.disable("The amount of " + slot + "s for recipe " + recipeKey + " for " + generatorKey + " must be a positive integer!");
                            return false;
                        }
                    }
                    if (amount < 0) {
                        Utils.disable("The amount of " + slot + "s for recipe " + recipeKey + " for " + generatorKey + " must be a positive integer!");
                        return false;
                    }
                    if (type.equalsIgnoreCase("VANILLA")) {
                        Material vanillaMat = Material.getMaterial((String)material);
                        if (vanillaMat == null) {
                            Utils.disable("The " + slot + "ingredient for recipe" + recipeKey + " for " + generatorKey + " is not a valid vanilla ID!");
                            return false;
                        }
                        if (i == 0) {
                            input = new ItemStack(vanillaMat);
                            input.setAmount(amount);
                            if (Utils.checkFitsStackSize(input, slot, generatorKey, recipeKey)) continue;
                            return false;
                        }
                        output = new ItemStack(vanillaMat);
                        output.setAmount(amount);
                        if (Utils.checkFitsStackSize(output, slot, generatorKey, recipeKey)) continue;
                        return false;
                    }
                    if (type.equalsIgnoreCase("SLIMEFUN")) {
                        SlimefunItem sfMat = SlimefunItem.getById((String)material);
                        if (sfMat == null) {
                            Utils.disable("The " + slot + " ingredient for recipe" + recipeKey + " for " + generatorKey + " is not a valid Slimefun ID!");
                            return false;
                        }
                        if (i == 0) {
                            input = sfMat.getItem().clone();
                            input.setAmount(amount);
                            if (Utils.checkFitsStackSize(input, slot, generatorKey, recipeKey)) continue;
                            return false;
                        }
                        output = sfMat.getItem().clone();
                        output.setAmount(amount);
                        if (Utils.checkFitsStackSize(output, slot, generatorKey, recipeKey)) continue;
                        return false;
                    }
                    if (type.equalsIgnoreCase("SAVEDITEM")) {
                        ItemStack savedItem = Utils.retrieveSavedItem(material, amount, true);
                        if (savedItem == null) {
                            return false;
                        }
                        if (!(i == 0 ? !Utils.checkFitsStackSize(input = savedItem.clone(), slot, generatorKey, recipeKey) : !Utils.checkFitsStackSize(output = savedItem.clone(), slot, generatorKey, recipeKey))) continue;
                        return false;
                    }
                    if (i == 0) {
                        Utils.disable("The " + slot + " ingredient type for recipe" + recipeKey + " for " + generatorKey + " can only be VANILLA, SLIMEFUN, or SAVEDITEM!");
                        return false;
                    }
                    if (type.equalsIgnoreCase("NONE")) continue;
                    Utils.disable("The " + slot + " ingredient type for recipe" + recipeKey + " for " + generatorKey + " can only be VANILLA, SLIMEFUN, SAVEDITEM, or NONE!");
                    return false;
                }
                customRecipe.add(new MachineFuel(time, input, output));
            }
            new CustomGenerator(category, generator.getMachineStack(), generator.getRecipeType(), generator.getRecipe(), generator.getProgressItem(), generator.getEnergyProduction(), generator.getEnergyBuffer(), customRecipe).register(SlimeCustomizer.getInstance());
            Utils.notify("Generator " + generatorKey + " has been registered!");
        }
        return true;
    }
}

