/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.slimecustomizer;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.ncbpfluffybear.slimecustomizer.Events;
import io.ncbpfluffybear.slimecustomizer.SCTabCompleter;
import io.ncbpfluffybear.slimecustomizer.Utils;
import io.ncbpfluffybear.slimecustomizer.bstats.bukkit.Metrics;
import io.ncbpfluffybear.slimecustomizer.objects.SCMenu;
import io.ncbpfluffybear.slimecustomizer.objects.WindowsExplorerStringComparator;
import io.ncbpfluffybear.slimecustomizer.registration.Categories;
import io.ncbpfluffybear.slimecustomizer.registration.Generators;
import io.ncbpfluffybear.slimecustomizer.registration.Items;
import io.ncbpfluffybear.slimecustomizer.registration.Machines;
import io.ncbpfluffybear.slimecustomizer.registration.MobDrops;
import io.ncbpfluffybear.slimecustomizer.registration.SolarGenerators;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SlimeCustomizer
extends JavaPlugin
implements SlimefunAddon {
    public static SlimeCustomizer instance;
    public static File itemsFolder;

    public void onEnable() {
        instance = this;
        itemsFolder = new File(this.getDataFolder(), "saveditems");
        Config cfg = new Config((Plugin)this);
        if (cfg.getBoolean("options.auto-update") && this.getDescription().getVersion().startsWith("Dev - ")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "SlimeCustomizer", "Dev").start();
        }
        Metrics metrics = new Metrics(this, 9841);
        File categoriesFile = new File(SlimeCustomizer.getInstance().getDataFolder(), "categories.yml");
        this.copyFile(categoriesFile, "categories");
        File itemsFile = new File(SlimeCustomizer.getInstance().getDataFolder(), "items.yml");
        this.copyFile(itemsFile, "items");
        File mobDropsFile = new File(SlimeCustomizer.getInstance().getDataFolder(), "mob-drops.yml");
        this.copyFile(mobDropsFile, "mob-drops");
        File machinesFile = new File(SlimeCustomizer.getInstance().getDataFolder(), "machines.yml");
        this.copyFile(machinesFile, "machines");
        File generatorsFile = new File(SlimeCustomizer.getInstance().getDataFolder(), "generators.yml");
        this.copyFile(generatorsFile, "generators");
        File solarGeneratorsFile = new File(SlimeCustomizer.getInstance().getDataFolder(), "solar-generators.yml");
        this.copyFile(solarGeneratorsFile, "solar-generators");
        if (!itemsFolder.exists()) {
            try {
                Files.createDirectory(itemsFolder.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                SlimeCustomizer.getInstance().getLogger().log(Level.SEVERE, "Failed to create saveditems folder", e);
            }
        }
        Config categories = new Config((Plugin)this, "categories.yml");
        Config items = new Config((Plugin)this, "items.yml");
        Config machines = new Config((Plugin)this, "machines.yml");
        Config generators = new Config((Plugin)this, "generators.yml");
        Config solarGenerators = new Config((Plugin)this, "solar-generators.yml");
        Config passiveMachines = new Config((Plugin)this, "passive-machines.yml");
        Config mobDrops = new Config((Plugin)this, "mob-drops.yml");
        this.getCommand("slimecustomizer").setTabCompleter((TabCompleter)new SCTabCompleter());
        Bukkit.getConsoleSender().sendMessage("[SlimeCustomizer] " + ChatColor.BLUE + "Setting up custom stuff...");
        if (!Categories.register(categories)) {
            return;
        }
        if (!Items.register(items)) {
            return;
        }
        if (!Machines.register(machines)) {
            return;
        }
        if (!Generators.register(generators)) {
            return;
        }
        if (!SolarGenerators.register(solarGenerators)) {
            return;
        }
        if (!MobDrops.register(mobDrops)) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)new Events(), (Plugin)instance);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && args[0].equals("saveitem")) {
            Player p = (Player)sender;
            if (!Utils.checkPermission(p, "slimecustomizer.admin")) {
                return true;
            }
            int id = 0;
            File itemFile = new File(SlimeCustomizer.getInstance().getDataFolder().getPath() + "/saveditems", id + ".yml");
            while (itemFile.exists()) {
                itemFile = new File(SlimeCustomizer.getInstance().getDataFolder().getPath() + "/saveditems", ++id + ".yml");
            }
            if (!itemFile.createNewFile()) {
                SlimeCustomizer.getInstance().getLogger().log(Level.SEVERE, "Failed to create config for item " + id);
            }
            Config itemFileConfig = new Config((Plugin)this, "saveditems/" + id + ".yml");
            itemFileConfig.setValue("item", (Object)p.getInventory().getItemInMainHand());
            itemFileConfig.save();
            Utils.send((CommandSender)p, "&eYour item has been saved to " + itemFile.getPath() + ". Please refer to &9" + "https://github.com/NCBPFluffyBear/SlimeCustomizer#using-custom-items");
        } else if (args[0].equals("give") && args.length > 2) {
            int amount;
            if (sender instanceof Player && !Utils.checkPermission((Player)sender, "slimecustomizer.admin")) {
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                Utils.send(sender, "&cThat player could not be found!");
                return true;
            }
            SlimefunItem sfItem = SlimefunItem.getById((String)args[2].toUpperCase());
            if (sfItem == null) {
                Utils.send(sender, "&cThat Slimefun item could not be found!");
                return true;
            }
            if (args[3] != null) {
                try {
                    amount = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException ignored) {
                    amount = 1;
                }
            } else {
                amount = 1;
            }
            this.giveItems(sender, target, sfItem, amount);
        } else if (args[0].equals("getsaveditem") && args.length > 1) {
            if (sender instanceof Player && !Utils.checkPermission((Player)sender, "slimecustomizer.admin")) {
                return true;
            }
            if (args[1].equals("gui")) {
                if (!(sender instanceof Player)) {
                    Utils.send(sender, "&4This command can only be executed in game");
                    return true;
                }
                Player p = (Player)sender;
                ArrayList<Pair<String, ItemStack>> items = new ArrayList<Pair<String, ItemStack>>();
                items.add(new Pair(null, null));
                String[] fileNames = itemsFolder.list();
                if (fileNames != null) {
                    for (int i = 0; i < fileNames.length; ++i) {
                        fileNames[i] = fileNames[i].replace(".yml", "");
                    }
                    Arrays.sort(fileNames, new WindowsExplorerStringComparator());
                    for (String id : fileNames) {
                        items.add(new Pair((Object)id, (Object)Utils.retrieveSavedItem(id, 1, false)));
                    }
                    int page = 1;
                    SCMenu menu = new SCMenu("&a&lSaved Items");
                    menu.setSize(54);
                    this.populateMenu(menu, items, page, p);
                    menu.setPlayerInventoryClickable(false);
                    menu.setBackgroundNonClickable(false);
                    menu.open(new Player[]{p});
                }
            } else {
                int amount;
                if (args.length < 4) {
                    Utils.send(sender, "&c/sc getsaveditem gui | <item_id> <player_name> <amount>");
                    return true;
                }
                String savedID = args[1];
                Player target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    Utils.send(sender, "&cThat player could not be found!");
                    return true;
                }
                try {
                    amount = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException ignored) {
                    amount = 1;
                }
                ItemStack item = Utils.retrieveSavedItem(savedID, amount, false);
                if (item != null) {
                    HashMap leftovers = target.getInventory().addItem(new ItemStack[]{item});
                    for (ItemStack leftover : leftovers.values()) {
                        target.getWorld().dropItem(target.getLocation(), leftover);
                    }
                    Utils.send(sender, "&bYou have given " + target.getName() + " &a" + amount + " &bof &7\"&a" + savedID + "&7\"");
                } else {
                    Utils.send(sender, "&cThat saveditem could not be found!");
                }
            }
        } else if (sender instanceof Player && args[0].equals("categories")) {
            Player p = (Player)sender;
            if (!Utils.checkPermission(p, "slimecustomizer.admin")) {
                return true;
            }
            SCMenu menu = new SCMenu("&6Category Namespace Guide");
            menu.setSize(54);
            int slot = 0;
            for (ItemGroup group : Slimefun.getRegistry().getAllItemGroups()) {
                ItemStack catItem = group.getItem(p).clone();
                ItemMeta catMeta = catItem.getItemMeta();
                List catLore = catMeta.getLore();
                catLore.set(catLore.size() - 1, Utils.color("&6ID: " + group.getKey().getNamespace() + ":" + group.getKey().getKey()));
                catMeta.setLore(catLore);
                catItem.setItemMeta(catMeta);
                menu.replaceExistingItem(slot, catItem);
                menu.addMenuClickHandler(slot, ChestMenuUtils.getEmptyClickHandler());
                ++slot;
            }
            menu.setPlayerInventoryClickable(false);
            menu.setBackgroundNonClickable(true);
            menu.open(new Player[]{p});
        } else {
            Utils.send(sender, "&eAll commands can be found at &9https://github.com/NCBPFluffyBear/SlimeCustomizer#commands");
        }
        return true;
    }

    private void populateMenu(SCMenu menu, List<Pair<String, ItemStack>> items, int page, Player p) {
        int i;
        for (i = 45; i < 54; ++i) {
            menu.replaceExistingItem(i, ChestMenuUtils.getBackground());
        }
        menu.wipe(0, 44, true);
        for (i = 0; i < 45; ++i) {
            int itemIndex = i + 1 + (page - 1) * 45;
            ItemStack item = this.getItemOrNull(items, itemIndex);
            if (item == null) continue;
            ItemMeta im = item.getItemMeta();
            if (im == null) {
                Utils.notify("An item has no metadata! Is it corrupted? " + (String)items.get(itemIndex).getFirstValue());
                continue;
            }
            ArrayList<String> lore = im.getLore();
            if (lore == null) {
                lore = new ArrayList<String>(Arrays.asList("", Utils.color("&bID: " + (String)items.get(itemIndex).getFirstValue()), Utils.color("&a> Click to get this item")));
            } else {
                lore.addAll(new ArrayList<String>(Arrays.asList("", Utils.color("&bID: " + (String)items.get(itemIndex).getFirstValue()), Utils.color("&a> Click to get this item"))));
            }
            im.setLore(lore);
            item.setItemMeta(im);
            menu.replaceExistingItem(i, item);
            menu.addMenuClickHandler(i, (pl, s, is, action) -> {
                HashMap leftovers = p.getInventory().addItem(new ItemStack[]{this.getItemOrNull(items, itemIndex)});
                for (ItemStack leftover : leftovers.values()) {
                    p.getWorld().dropItem(p.getLocation(), leftover);
                }
                return false;
            });
        }
        if (page != 1) {
            menu.replaceExistingItem(46, (ItemStack)new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&aPrevious Page", new String[0]));
            menu.addMenuClickHandler(46, (pl, s, is, action) -> {
                this.populateMenu(menu, items, page - 1, p);
                return false;
            });
        }
        if (this.getItemOrNull(items, 45 * page) != null) {
            menu.replaceExistingItem(52, (ItemStack)new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&aNext Page", new String[0]));
            menu.addMenuClickHandler(52, (pl, s, is, action) -> {
                this.populateMenu(menu, items, page + 1, p);
                return false;
            });
        }
    }

    private ItemStack getItemOrNull(List<Pair<String, ItemStack>> items, int index) {
        ItemStack item;
        try {
            item = ((ItemStack)items.get(index).getSecondValue()).clone();
        }
        catch (IndexOutOfBoundsException e) {
            item = null;
        }
        return item;
    }

    private void giveItems(CommandSender s, Player p, SlimefunItem sfItem, int amount) {
        p.getInventory().addItem(new ItemStack[]{new CustomItemStack(sfItem.getRecipeOutput(), amount)});
        Utils.send(s, "&bYou have given " + p.getName() + " &a" + amount + " &7\"&b" + sfItem.getItemName() + "&7\"");
    }

    private void copyFile(File file, String name) {
        if (!file.exists()) {
            try {
                Files.copy(((Object)((Object)this)).getClass().getResourceAsStream("/" + name + ".yml"), file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                SlimeCustomizer.getInstance().getLogger().log(Level.SEVERE, "Failed to copy default " + name + ".yml file", e);
            }
        }
    }

    public void onDisable() {
    }

    public String getBugTrackerURL() {
        return "https://github.com/NCBPFluffyBear/SlimeCustomizer/issues";
    }

    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public static SlimeCustomizer getInstance() {
        return instance;
    }
}

