/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.slimecustomizer;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.ncbpfluffybear.slimecustomizer.SlimeCustomizer;
import io.ncbpfluffybear.slimecustomizer.objects.CustomGenerator;
import io.ncbpfluffybear.slimecustomizer.objects.CustomMachine;
import io.ncbpfluffybear.slimecustomizer.objects.CustomSCItem;
import io.ncbpfluffybear.slimecustomizer.objects.WindowsExplorerStringComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SCTabCompleter
implements TabCompleter {
    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        LinkedList<String> options = new LinkedList<String>();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 1) {
                if (player.hasPermission("slimecustomizer.admin")) {
                    options.add("saveitem");
                    options.add("give");
                    options.add("getsaveditem");
                    options.add("categories");
                }
            } else if (args[0].equals("give") && player.hasPermission("slimecustomizer.admin")) {
                switch (args.length) {
                    case 2: {
                        options.addAll(this.getOnlinePlayers());
                        break;
                    }
                    case 3: {
                        options.addAll(this.getSCItems());
                        break;
                    }
                    case 4: {
                        Collections.addAll(options, "1", "2", "4", "8", "16", "32", "64");
                    }
                }
            } else if (args[0].equals("getsaveditem") && player.hasPermission("slimecustomizer.admin")) {
                if (args.length == 2) {
                    options.add("gui");
                    String[] fileNames = SlimeCustomizer.itemsFolder.list();
                    if (fileNames != null) {
                        for (int i = 0; i < fileNames.length; ++i) {
                            fileNames[i] = fileNames[i].replace(".yml", "");
                        }
                        Arrays.sort(fileNames, new WindowsExplorerStringComparator());
                        options.addAll(Arrays.asList(fileNames));
                    }
                } else if (!args[1].equals("gui")) {
                    if (args.length == 3) {
                        options.addAll(this.getOnlinePlayers());
                    } else if (args.length == 4) {
                        Collections.addAll(options, "1", "2", "4", "8", "16", "32", "64");
                    }
                }
            }
        }
        return options;
    }

    private List<String> getSCItems() {
        List items = Slimefun.getRegistry().getEnabledSlimefunItems();
        ArrayList<String> list = new ArrayList<String>(items.size());
        for (SlimefunItem item : items) {
            if (!(item instanceof CustomSCItem) && !(item instanceof CustomGenerator) && !(item instanceof CustomMachine)) continue;
            list.add(item.getId());
        }
        return list;
    }

    private List<String> getOnlinePlayers() {
        ArrayList<String> players = new ArrayList<String>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            players.add(p.getName());
        }
        return players;
    }
}

