/*
 * Decompiled with CFR 0.152.
 */
package io.ncbpfluffybear.slimecustomizer.objects;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.ncbpfluffybear.slimecustomizer.extrautils.utils.LoreBuilderDynamic;
import io.ncbpfluffybear.slimecustomizer.extrautils.utils.Utils;
import io.ncbpfluffybear.slimecustomizer.objects.SCAGenerator;
import java.util.ArrayList;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class CustomGenerator
extends SCAGenerator {
    private final ItemStack progressItem;
    private final int energyProduction;
    private final int energyBuffer;
    private final List<MachineFuel> customRecipes;

    public CustomGenerator(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Material progressItem, int energyProduction, int energyBuffer, List<MachineFuel> customRecipes) {
        super(category, item, recipeType, recipe);
        this.progressItem = new CustomItemStack(progressItem, "", new String[0]);
        this.energyProduction = energyProduction;
        this.energyBuffer = energyBuffer;
        this.customRecipes = customRecipes;
        this.getMachineProcessor().setProgressBar(this.getProgressBar());
        this.registerDefaultFuelTypes();
    }

    public ItemStack getProgressBar() {
        return this.progressItem;
    }

    protected void registerDefaultFuelTypes() {
        if (this.customRecipes == null) {
            return;
        }
        for (MachineFuel fuel : this.customRecipes) {
            this.registerFuel(fuel);
        }
    }

    @Override
    public int getEnergyProduction() {
        return this.energyProduction;
    }

    @Override
    public int getCapacity() {
        return this.energyBuffer;
    }

    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> displayRecipes = new ArrayList<ItemStack>(this.customRecipes.size() * 2);
        for (MachineFuel fuel : this.customRecipes) {
            ItemStack input = fuel.getInput();
            CustomItemStack customInput = new CustomItemStack(input, input.getItemMeta().getDisplayName(), new String[]{"&8\u21e8 &7Lasts " + Utils.ticksToSeconds(fuel.getTicks()), LoreBuilderDynamic.powerPerTick(this.getEnergyProduction()), "&8\u21e8 &e\u26a1 &7" + fuel.getTicks() * this.getEnergyProduction() + " J in total"});
            displayRecipes.add((ItemStack)customInput);
            if (fuel.getOutput() != null) {
                displayRecipes.add(fuel.getOutput());
                continue;
            }
            displayRecipes.add((ItemStack)new CustomItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "&7No Output", new String[0]));
        }
        return displayRecipes;
    }
}

