/*
 * Decompiled with CFR 0.152.
 */
package me.fnfal113.sfheadconverter.commands;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerHead;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.fnfal113.sfheadconverter.Utils.Utils;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class ScanChunk
implements TabExecutor {
    private final Map<String, Integer> convertedBlocksCountMap = new HashMap<String, Integer>();
    private final String[] headIdArr = new String[]{"ENERGY_CONNECTOR", "CARGO_NODE", "CARGO_NODE_INPUT", "CARGO_NODE_OUPUT", "CARGO_NODE_OUPUT_ADVANCED"};
    private final Map<String, PlayerSkin> materialToHeadSkinMap = Map.ofEntries(Map.entry("ENERGY_CONNECTOR", HeadTexture.ENERGY_CONNECTOR.getAsSkin()), Map.entry("CARGO_NODE", HeadTexture.CARGO_CONNECTOR_NODE.getAsSkin()), Map.entry("CARGO_NODE_INPUT", HeadTexture.CARGO_INPUT_NODE.getAsSkin()), Map.entry("CARGO_NODE_OUPUT", HeadTexture.CARGO_OUTPUT_NODE.getAsSkin()), Map.entry("CARGO_NODE_OUPUT_ADVANCED", HeadTexture.CARGO_OUTPUT_NODE.getAsSkin()));
    private List<String> materialNameArgs = new ArrayList<String>();
    private List<String> headsToConvertArgs = new ArrayList<String>();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 2) {
                if (player.hasPermission("sfheadconverter")) {
                    Chunk chunk = player.getLocation().getChunk();
                    this.getAmount(chunk, player, args);
                } else {
                    Utils.sendMessage(player, "You don't have permission to use this command (perm mode: sfheadconverter)");
                }
            }
        }
        return true;
    }

    public void getAmount(Chunk chunk, Player player, String[] args) {
        if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), player.getLocation(), Interaction.PLACE_BLOCK)) {
            Utils.sendMessage(player, "You don't have the permission to convert blocks on this chunk (Grief Protected), ask for permission or override using the protection plugin command");
            return;
        }
        if (!this.scanChunkAndConvert(chunk, player, args)) {
            return;
        }
        player.sendMessage(new String[]{ChatColor.GOLD + "# of Slimefun heads converted on this chunk:", ""});
        if (this.convertedBlocksCountMap.isEmpty()) {
            player.sendMessage(new String[]{ChatColor.YELLOW + "No Slimefun heads to be converted on this chunk", ""});
            return;
        }
        this.convertedBlocksCountMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEachOrdered(e -> player.sendMessage(new String[]{(String)e.getKey() + ": " + ChatColor.GOLD + e.getValue(), ""}));
        this.convertedBlocksCountMap.clear();
    }

    public boolean scanChunkAndConvert(Chunk chunk, Player player, String[] args) {
        if (!this.headsToConvertArgs.contains(args[0].toUpperCase()) || !this.materialNameArgs.contains(args[1].toUpperCase())) {
            Utils.sendMessage(player, "Invalid parameters, please select from suggested parameters!");
            return false;
        }
        for (int y = chunk.getWorld().getMinHeight(); y <= chunk.getWorld().getMaxHeight() - 1; ++y) {
            for (int x = 0; x <= 15; ++x) {
                for (int z = 0; z <= 15; ++z) {
                    SlimefunItem sfItem;
                    String sfId;
                    Block block = chunk.getBlock(x, y, z);
                    if (block.getType() == Material.AIR || BlockStorage.check((Block)block) == null || !args[0].equals(sfId = (sfItem = BlockStorage.check((Block)block)).getId())) continue;
                    String sfBlockName = Objects.requireNonNull(sfItem).getItemName();
                    if (Material.getMaterial((String)args[1]) != null) {
                        block.setType(Material.getMaterial((String)args[1]));
                        this.convertedBlocksCountMap.put(sfBlockName, this.convertedBlocksCountMap.getOrDefault(sfBlockName, 0) + 1);
                        continue;
                    }
                    if (!args[1].toUpperCase().equals("RESET")) continue;
                    block.setType(Material.PLAYER_HEAD);
                    PlayerHead.setSkin((Block)block, (PlayerSkin)this.materialToHeadSkinMap.get(sfId), (boolean)true);
                    this.convertedBlocksCountMap.put(sfBlockName, this.convertedBlocksCountMap.getOrDefault(sfBlockName, 0) + 1);
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            for (String headId : this.headIdArr) {
                this.headsToConvertArgs.add(headId);
            }
            if (args[0].length() > 0) {
                this.headsToConvertArgs = this.headsToConvertArgs.stream().filter(m -> m.toLowerCase().contains(args[0].toLowerCase())).collect(Collectors.toList());
            }
            return this.headsToConvertArgs;
        }
        if (args.length == 2) {
            this.materialNameArgs.add("RESET");
            HashSet materials = new HashSet(Tag.WOOL.getValues());
            materials.addAll(Stream.of(Material.values()).filter(m -> m.name().contains("_STAINED_GLASS")).collect(Collectors.toSet()));
            for (Material material : materials) {
                this.materialNameArgs.add(material.name());
            }
            if (args[1].length() > 0) {
                this.materialNameArgs = this.materialNameArgs.stream().filter(m -> m.toLowerCase().contains(args[1].toLowerCase())).collect(Collectors.toList());
            }
            return this.materialNameArgs;
        }
        return null;
    }
}

