/*
 * Decompiled with CFR 0.152.
 */
package me.fnfal113.sfchunkinfo.commands;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.WorldUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class ScanChunk
implements TabExecutor {
    private final Map<String, Integer> AMOUNT = new HashMap<String, Integer>();
    private final Map<String, String> INFO = new HashMap<String, String>();
    private final Map<String, Double> TIMINGS = new HashMap<String, Double>();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                if (player.hasPermission("sfchunkinfo.scan")) {
                    Chunk chunk = player.getLocation().getChunk();
                    this.getAmount(chunk, player);
                } else {
                    player.sendMessage("You don't have permission to use this command (perm mode: sfchunkinfo.scan)");
                }
            } else if (player.hasPermission("sfchunkinfo.scan.others")) {
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    player.sendMessage("Player should not be null nor offline");
                    return true;
                }
                Chunk chunk = target.getLocation().getChunk();
                this.getAmountOthers(chunk, target, player);
            } else {
                player.sendMessage("You don't have permission to use this command (perm mode: sfchunkinfo.scan.others)");
            }
        }
        return true;
    }

    public void getAmount(Chunk chunk, Player player) {
        if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()), player.getLocation(), Interaction.PLACE_BLOCK)) {
            player.sendMessage("You don't have the permission to scan this chunk (Grief Protected), ask for permission or override using the protection plugin command");
            return;
        }
        this.scanChunk(chunk);
        player.sendMessage(new String[]{ChatColor.GOLD + "# of Slimefun blocks on this chunk:", ""});
        if (this.AMOUNT.isEmpty()) {
            player.sendMessage(ChatColor.YELLOW + "No Slimefun blocks on this chunk");
            return;
        }
        this.sendResults(player);
    }

    public void getAmountOthers(Chunk chunk, Player player, Player sender) {
        this.scanChunk(chunk);
        sender.sendMessage(new String[]{ChatColor.GOLD + "# of Slimefun blocks on " + ChatColor.WHITE + player.getName() + ChatColor.GOLD + " chunk:", ""});
        if (this.AMOUNT.isEmpty()) {
            sender.sendMessage(ChatColor.YELLOW + "No Slimefun blocks on " + ChatColor.WHITE + player.getName() + ChatColor.GOLD + " chunk");
            return;
        }
        this.sendResults(sender);
    }

    public void scanChunk(Chunk chunk) {
        for (int y = WorldUtils.getMinHeight((World)chunk.getWorld()); y <= chunk.getWorld().getMaxHeight() - 1; ++y) {
            for (int x = 0; x <= 15; ++x) {
                for (int z = 0; z <= 15; ++z) {
                    Block sfBlock = chunk.getBlock(x, y, z);
                    if (BlockStorage.check((Block)sfBlock) == null) continue;
                    this.TIMINGS.put(Objects.requireNonNull(BlockStorage.check((Block)sfBlock)).getItemName(), this.TIMINGS.getOrDefault(Objects.requireNonNull(BlockStorage.check((Block)sfBlock)).getItemName(), 0.0) + Double.parseDouble(Slimefun.getProfiler().getTime(sfBlock).substring(0, Slimefun.getProfiler().getTime(sfBlock).length() - 2)));
                    this.INFO.put(Objects.requireNonNull(BlockStorage.check((Block)sfBlock)).getItemName(), Objects.requireNonNull(BlockStorage.check((Block)sfBlock)).getAddon().getName());
                    this.AMOUNT.put(Objects.requireNonNull(BlockStorage.check((Block)sfBlock)).getItemName(), this.AMOUNT.getOrDefault(Objects.requireNonNull(BlockStorage.check((Block)sfBlock)).getItemName(), 0) + 1);
                }
            }
        }
    }

    public void sendResults(Player player) {
        this.AMOUNT.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(e -> player.sendMessage((String)e.getKey() + ": " + ChatColor.GREEN + e.getValue()));
        player.spigot().sendMessage((BaseComponent)this.hoverInfo(this.INFO));
        player.spigot().sendMessage((BaseComponent)this.hoverInfoTimings(this.TIMINGS));
        this.AMOUNT.clear();
        this.INFO.clear();
        this.TIMINGS.clear();
    }

    public TextComponent hoverInfo(Map<String, String> info) {
        TextComponent infoAddon = new TextComponent("\nHover for some info");
        infoAddon.setColor(net.md_5.bungee.api.ChatColor.LIGHT_PURPLE);
        infoAddon.setItalic(Boolean.valueOf(true));
        infoAddon.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(info.toString().replace("{", "").replace("}", "").replace(", ", "\n").replace("=", ChatColor.WHITE + " | from: "))}));
        return infoAddon;
    }

    public TextComponent hoverInfoTimings(Map<String, Double> timings) {
        TextComponent infoChunk = new TextComponent("Hover for block total timings");
        infoChunk.setColor(net.md_5.bungee.api.ChatColor.LIGHT_PURPLE);
        infoChunk.setItalic(Boolean.valueOf(true));
        infoChunk.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(ChatColor.GOLD + "Total Timings\n\n" + timings.toString().replace("{", "").replace("}", "").replace(", ", " ms\n").replace("=", ChatColor.WHITE + ": ").concat(ChatColor.WHITE + " ms"))}));
        return infoChunk;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> playerNames = new ArrayList<String>();
            Player[] players = new Player[Bukkit.getServer().getOnlinePlayers().size()];
            Bukkit.getServer().getOnlinePlayers().toArray(players);
            for (Player player : players) {
                playerNames.add(player.getName());
            }
            return playerNames;
        }
        return null;
    }
}

