/*
 * Decompiled with CFR 0.152.
 */
package me.fnfal113.sfchunkinfo.dough.versions;

import java.util.Objects;
import javax.annotation.Nonnull;
import me.fnfal113.sfchunkinfo.dough.versions.AbstractNumericVersion;
import me.fnfal113.sfchunkinfo.dough.versions.Version;
import org.apache.commons.lang.Validate;

public class PrefixedVersion
extends AbstractNumericVersion {
    private final String prefix;

    public PrefixedVersion(@Nonnull String prefix, int version) {
        super(version);
        Validate.notNull((Object)prefix, (String)"The prefix cannot be null.");
        this.prefix = prefix;
    }

    @Override
    public boolean isSimilar(@Nonnull Version version) {
        return version instanceof PrefixedVersion && this.prefix.equals(((PrefixedVersion)version).getPrefix());
    }

    @Override
    @Nonnull
    public String getAsString() {
        return this.prefix + this.getVersionNumber();
    }

    @Nonnull
    public final String getPrefix() {
        return this.prefix;
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.getVersionNumber());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version && this.isSimilar((Version)obj)) {
            return this.isEqualTo((Version)obj);
        }
        return false;
    }

    public String toString() {
        return "PrefixedVersion [" + this.getAsString() + "]";
    }
}

