/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.sanecrafting.patches;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.lang.reflect.Field;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.metamechanists.sanecrafting.SaneCrafting;

public final class RecipeLorePatch {
    private static final ItemStack ITEMSTACK = new CustomItemStack(Material.CRAFTING_TABLE, "&bShaped Crafting Recipe", new String[0]);
    private static final NamespacedKey KEY = new NamespacedKey("minecraft", "shaped");

    public static void apply() {
        try {
            for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
                if (!item.getRecipeType().equals((Object)RecipeType.ENHANCED_CRAFTING_TABLE)) continue;
                Field recipeTypeItemField = RecipeType.class.getDeclaredField("item");
                recipeTypeItemField.setAccessible(true);
                recipeTypeItemField.set(RecipeType.ENHANCED_CRAFTING_TABLE, ITEMSTACK);
                Field recipeTypeKeyField = RecipeType.class.getDeclaredField("key");
                recipeTypeKeyField.setAccessible(true);
                recipeTypeKeyField.set(RecipeType.ENHANCED_CRAFTING_TABLE, KEY);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            SaneCrafting.getInstance().getLogger().info("Failed to apply ChangeRecipeTypePatch");
            e.printStackTrace();
            return;
        }
        SaneCrafting.getInstance().getLogger().info("Applied RecipeLore patch");
    }

    private RecipeLorePatch() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

