/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.sanecrafting.patches;

import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.EnhancedCraftingTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import org.metamechanists.sanecrafting.SaneCrafting;
import org.metamechanists.sanecrafting.Util;

public final class CraftingTablePatch {
    @Nullable
    private static List<ItemStack[]> getRecipes() {
        EnhancedCraftingTable enhancedCraftingTable = Util.findMultiblock(EnhancedCraftingTable.class);
        if (enhancedCraftingTable == null) {
            return null;
        }
        return enhancedCraftingTable.getRecipes();
    }

    private static void convertRecipe(List<ItemStack> input, ItemStack output) {
        int y;
        NamespacedKey key = new NamespacedKey((Plugin)SaneCrafting.getInstance(), Util.generateRecipeId(output));
        if (Bukkit.getServer().getRecipe(key) != null) {
            Bukkit.getServer().removeRecipe(key);
        }
        String itemCharacters = "abcdefghi";
        ArrayList<String> shape = new ArrayList<String>(List.of("abc", "def", "ghi"));
        HashMap<Character, ItemStack> ingredients = new HashMap<Character, ItemStack>();
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int i = y * 3 + x;
                char character = itemCharacters.charAt(i);
                ItemStack itemStack = input.get(i);
                if (itemStack == null) {
                    shape.set(y, ((String)shape.get(y)).replace(character, ' '));
                    continue;
                }
                ingredients.put(Character.valueOf(character), itemStack);
            }
        }
        for (y = shape.size() - 1; y >= 0; --y) {
            if (!Objects.equals(shape.get(y), "   ")) continue;
            shape.remove(y);
        }
        if (shape.isEmpty()) {
            return;
        }
        for (int x = ((String)shape.get(0)).length() - 1; x >= 0; --x) {
            int y2;
            boolean allRowsEmptyAtX = true;
            for (y2 = shape.size() - 1; y2 >= 0; --y2) {
                if (((String)shape.get(y2)).charAt(x) == ' ') continue;
                allRowsEmptyAtX = false;
                break;
            }
            if (!allRowsEmptyAtX) continue;
            for (y2 = shape.size() - 1; y2 >= 0; --y2) {
                String newRow = new StringBuilder((String)shape.get(y2)).deleteCharAt(x).toString();
                shape.set(y2, newRow);
            }
        }
        ShapedRecipe recipe = new ShapedRecipe(key, output);
        recipe.shape(shape.toArray(new String[0]));
        for (Map.Entry entry : ingredients.entrySet()) {
            recipe.setIngredient(((Character)entry.getKey()).charValue(), (ItemStack)entry.getValue());
        }
        Bukkit.getServer().addRecipe((Recipe)recipe);
    }

    public static void apply() {
        List<ItemStack[]> recipes = CraftingTablePatch.getRecipes();
        if (recipes == null) {
            return;
        }
        int changedRecipes = 0;
        for (int j = 0; j < recipes.size(); j += 2) {
            ItemStack[] input = recipes.get(j);
            ItemStack output = recipes.get(j + 1)[0];
            try {
                CraftingTablePatch.convertRecipe(Arrays.asList(input), output);
            }
            catch (RuntimeException e) {
                String name = PlainTextComponentSerializer.plainText().serialize(output.displayName());
                SaneCrafting.getInstance().getLogger().severe("Failed to convert Enhanced Crafting Table recipe for " + name);
                e.printStackTrace();
                continue;
            }
            ++changedRecipes;
        }
        SaneCrafting.getInstance().getLogger().info("Applied CraftingTable patch and converted " + changedRecipes + " Enhanced Crafting Table recipes to regular Crafing Table recipes");
    }

    private CraftingTablePatch() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

