/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.sanecrafting;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.metamechanists.sanecrafting.SaneCrafting;

public final class Util {
    private Util() {
    }

    @NotNull
    public static String generateRecipeId(@NotNull ItemStack output) {
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)output);
        String normalisedName = item != null ? item.getId().toLowerCase().replace(' ', '_').replaceAll("[^a-z0-9/._\\-]", "") : output.getType().name().toLowerCase().replace(' ', '_').replaceAll("[^a-z0-9/._\\-]", "");
        return "sanecrafting_" + normalisedName;
    }

    @Nullable
    public static <T extends SlimefunItem> T findMultiblock(Class<T> clazz) {
        for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            if (!clazz.isInstance(item)) continue;
            return (T)((SlimefunItem)clazz.cast(item));
        }
        SaneCrafting.getInstance().getLogger().severe("Failed to initialise SaneCrafting; EnhancedCraftingTable does not exist!");
        return null;
    }
}

