/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.sanecrafting.patches;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.sanecrafting.SaneCrafting;

public final class UsableInWorkbenchPatch
implements Listener {
    private static final Set<String> usableInWorkbench = new HashSet<String>();

    private UsableInWorkbenchPatch() {
    }

    public static void apply() {
        for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            if (item.isUseableInWorkbench()) {
                usableInWorkbench.add(item.getId());
            }
            item.setUseableInWorkbench(true);
        }
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new UsableInWorkbenchPatch(), (Plugin)SaneCrafting.getInstance());
        SaneCrafting.getInstance().getLogger().info("Applied UsableInWorkbench patch");
    }

    @EventHandler
    public static void onCraft(@NotNull CraftItemEvent e) {
        if (SlimefunItem.getByItem((ItemStack)e.getInventory().getResult()) != null) {
            return;
        }
        for (ItemStack item : e.getInventory().getContents()) {
            SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
            if (sfItem == null || usableInWorkbench.contains(sfItem.getId())) continue;
            e.setResult(Event.Result.DENY);
            break;
        }
    }

    @EventHandler
    public static void onPrepareCraft(@NotNull PrepareItemCraftEvent e) {
        ItemStack result = e.getInventory().getResult();
        if (result == null) {
            return;
        }
        if (SlimefunItem.getByItem((ItemStack)result) != null) {
            return;
        }
        for (ItemStack item : e.getInventory().getContents()) {
            SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
            if (sfItem == null || usableInWorkbench.contains(sfItem.getId())) continue;
            e.getInventory().setResult(null);
            break;
        }
    }
}

