/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.sanecrafting.patches;

import io.github.thebusybiscuit.slimefun4.api.events.ResearchUnlockEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.sanecrafting.SaneCrafting;
import org.metamechanists.sanecrafting.Util;

public final class RecipeBookResearchPatch
implements Listener {
    private RecipeBookResearchPatch() {
    }

    public static void apply() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new RecipeBookResearchPatch(), (Plugin)SaneCrafting.getInstance());
        SaneCrafting.getInstance().getLogger().info("Applied RecipeBookResearch patch");
    }

    @EventHandler
    public static void onJoin(@NotNull PlayerJoinEvent e) {
        if (Slimefun.getRegistry().isResearchingEnabled()) {
            return;
        }
        for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            e.getPlayer().discoverRecipe(new NamespacedKey((Plugin)SaneCrafting.getInstance(), Util.generateRecipeId(item.getItem())));
        }
    }

    @EventHandler
    public static void onResearch(@NotNull ResearchUnlockEvent e) {
        for (SlimefunItem item : e.getResearch().getAffectedItems()) {
            e.getPlayer().discoverRecipe(new NamespacedKey((Plugin)SaneCrafting.getInstance(), Util.generateRecipeId(item.getItem())));
        }
    }

    @EventHandler
    public static void onCraft(@NotNull CraftItemEvent e) {
        SlimefunItem result = SlimefunItem.getByItem((ItemStack)e.getInventory().getResult());
        if (result == null) {
            return;
        }
        if (!result.hasResearch()) {
            return;
        }
        UUID uuid = e.getWhoClicked().getUniqueId();
        if (((PlayerProfile)Slimefun.getRegistry().getPlayerProfiles().get(uuid)).hasUnlocked(result.getResearch())) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public static void onPrepareCraft(@NotNull PrepareItemCraftEvent e) {
        SlimefunItem result = SlimefunItem.getByItem((ItemStack)e.getInventory().getResult());
        if (result == null) {
            return;
        }
        if (!result.hasResearch()) {
            return;
        }
        UUID uuid = e.getView().getPlayer().getUniqueId();
        if (((PlayerProfile)Slimefun.getRegistry().getPlayerProfiles().get(uuid)).hasUnlocked(result.getResearch())) {
            return;
        }
        e.getInventory().setResult(null);
    }
}

