/*
 * Decompiled with CFR 0.152.
 */
package dev.walshy.sfmobdrops;

import dev.walshy.sfmobdrops.Constants;
import dev.walshy.sfmobdrops.SfMobDrops;
import dev.walshy.sfmobdrops.drops.Drop;
import dev.walshy.sfmobdrops.drops.MobDrop;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;

public class Config {
    private SfMobDrops instance;

    public Config(SfMobDrops instance) {
        this.instance = instance;
    }

    @Nonnull
    public Set<MobDrop> loadConfig() {
        HashSet<MobDrop> mobDrops = new HashSet<MobDrop>();
        List list = this.instance.getConfig().getList("drops");
        if (list == null || list.isEmpty()) {
            return mobDrops;
        }
        for (Map map : list) {
            List dropsMap;
            Set<Drop> drops;
            String nbtTag;
            MobDrop.MobDropBuilder builder = MobDrop.builder();
            String entity = (String)map.get("entity");
            if (entity == null) {
                this.logSkipMsg("'entity' is not defined");
                continue;
            }
            if (!Constants.CONSTANT.asMatchPredicate().test(entity)) {
                this.logSkipMsg("'entity' should be in SCREAMING_SNAKE_CASE");
                continue;
            }
            if (entity.equals("ALL")) {
                builder.allMobs(true);
            } else {
                EntityType type;
                try {
                    type = EntityType.valueOf((String)entity);
                }
                catch (Exception e) {
                    this.logSkipMsg("Invalid entity type: " + entity);
                    continue;
                }
                builder.dropsFrom(type);
            }
            String name = (String)map.get("name");
            if (name != null) {
                builder.entityName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            if ((nbtTag = (String)map.get("nbtTag")) != null) {
                if (!Constants.NAMESPACE.asMatchPredicate().test(nbtTag)) {
                    this.logSkipMsg("'nbtTag' should be a valid namespace - e.g. 'some_plugin:custom_mob'");
                    continue;
                }
                NamespacedKey key = NamespacedKey.fromString((String)nbtTag);
                if (key == null) {
                    this.logSkipMsg("Invalid nbtTag: " + nbtTag);
                    continue;
                }
                builder.entityNbtTag(key);
            }
            Set<Drop> set = drops = (dropsMap = (List)map.get("drops")) != null ? this.loadDrop(dropsMap) : this.loadLegacyDrop(map);
            if (drops == null) continue;
            builder.drops(drops);
            mobDrops.add(builder.build());
        }
        return mobDrops;
    }

    @Nullable
    private Set<Drop> loadDrop(@Nonnull List<Map<String, Object>> map) {
        HashSet<Drop> drops = new HashSet<Drop>();
        for (Map<String, Object> dropMap : map) {
            Drop.DropBuilder builder = Drop.builder();
            String slimefunId = (String)dropMap.get("slimefunItem");
            if (slimefunId == null) {
                this.logSkipMsg("'slimefunItem' is not defined");
                return null;
            }
            builder.slimefunItem(slimefunId);
            Object chanceObj = dropMap.get("chance");
            if (chanceObj == null) {
                this.logSkipMsg("'chance' is not defined");
                return null;
            }
            builder.chance(this.getDouble(chanceObj));
            builder.amount(this.getInt(dropMap.get("amount")));
            drops.add(builder.build());
        }
        return drops;
    }

    @Nullable
    private Set<Drop> loadLegacyDrop(@Nonnull Map<String, Object> map) {
        this.instance.getLogger().warning("Loading legacy drop for " + map.get("entity") + ". Please update to the new format. The legacy format will be removed in the future.");
        Drop.DropBuilder builder = Drop.builder();
        String slimefunId = (String)map.get("slimefunItem");
        if (slimefunId == null) {
            this.logSkipMsg("'slimefunItem' is not defined");
            return null;
        }
        builder.slimefunItem(slimefunId);
        Object chanceObj = map.get("chance");
        if (chanceObj == null) {
            this.logSkipMsg("'chance' is not defined");
            return null;
        }
        builder.chance(this.getDouble(chanceObj));
        builder.amount(this.getInt(map.get("amount")));
        return Set.of(builder.build());
    }

    private void logSkipMsg(@Nonnull String reason) {
        this.instance.getLogger().warning(reason + ". Skipping invalid drop");
    }

    private int getInt(@Nullable Object obj) {
        return obj == null ? 1 : (Integer)obj;
    }

    private double getDouble(@Nullable Object obj) {
        return obj == null ? 1.0 : (obj instanceof Integer ? (double)((Integer)obj).intValue() : (Double)obj);
    }
}

