/*
 * Decompiled with CFR 0.152.
 */
package dev.walshy.sfmobdrops.dough.common;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class PlayerList {
    private PlayerList() {
    }

    @Nonnull
    public static Stream<Player> stream() {
        return Bukkit.getOnlinePlayers().stream().map(Player.class::cast);
    }

    @Nonnull
    public static Optional<Player> findByName(@Nonnull String name) {
        return PlayerList.stream().filter(p -> p.getName().equalsIgnoreCase(name)).findAny();
    }

    @Nonnull
    public static Set<Player> findPermitted(@Nonnull String permission) {
        return PlayerList.stream().filter(p -> p.hasPermission(permission)).collect(Collectors.toSet());
    }

    public static boolean isOnline(@Nonnull String name) {
        return PlayerList.findByName(name).isPresent();
    }
}

