/*
 * Decompiled with CFR 0.152.
 */
package dev.walshy.sfmobdrops;

import dev.walshy.sfmobdrops.Config;
import dev.walshy.sfmobdrops.Guis;
import dev.walshy.sfmobdrops.MobDropsCommand;
import dev.walshy.sfmobdrops.bstats.bukkit.Metrics;
import dev.walshy.sfmobdrops.dough.updater.BlobBuildUpdater;
import dev.walshy.sfmobdrops.drops.Drop;
import dev.walshy.sfmobdrops.drops.MobDrop;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.debug.Debug;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public class SfMobDrops
extends JavaPlugin
implements Listener {
    private static final String DEBUG = "sfmobdrops_debug";
    private static SfMobDrops instance;
    private final Set<MobDrop> mobDrops = new HashSet<MobDrop>();
    private Config config;
    private boolean unitTest;

    public SfMobDrops() {
    }

    protected SfMobDrops(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        this.unitTest = true;
    }

    public void onEnable() {
        SfMobDrops.setInstance(this);
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        if (this.getConfig().getBoolean("settings.autoUpdate", true) && this.getDescription().getVersion().toLowerCase().startsWith("dev - ")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "SFMobDrops").start();
        }
        if (!this.unitTest) {
            new Metrics(this, 11950);
        }
        this.config = new Config(this);
        this.loadDrops();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Guis(), (Plugin)this);
        this.getCommand("mobdrops").setExecutor((CommandExecutor)new MobDropsCommand());
    }

    public void onDisable() {
        SfMobDrops.setInstance(null);
    }

    protected void loadDrops() {
        Set<MobDrop> newSet = this.config.loadConfig();
        this.mobDrops.clear();
        this.mobDrops.addAll(newSet);
        this.getLogger().info("Loaded in " + this.mobDrops.size() + " drops!");
    }

    @EventHandler
    public void onMobDeath(@Nonnull EntityDeathEvent e) {
        Set<Drop> drops = this.findDropsFromEntity(e.getEntity());
        if (drops == null) {
            return;
        }
        Debug.log((String)DEBUG, (String)"Found mob drop, has {} drops", (Object[])new Object[]{drops.size()});
        for (Drop drop : drops) {
            SlimefunItem item;
            double chance = ThreadLocalRandom.current().nextDouble(100.0);
            Debug.log((String)DEBUG, (String)"Evaluating {} - {} <= {}", (Object[])new Object[]{drop.getSlimefunItem(), chance, drop.getChance()});
            if (!(chance <= drop.getChance()) || (item = SlimefunItem.getById((String)drop.getSlimefunItem())) == null || item.isDisabledIn(e.getEntity().getWorld())) continue;
            ItemStack dropping = item.getItem().clone();
            dropping.setAmount(drop.getAmount());
            Debug.log((String)DEBUG, (String)"Dropping {}x {}", (Object[])new Object[]{drop.getAmount(), drop.getSlimefunItem()});
            e.getDrops().add(dropping);
        }
    }

    @Nullable
    private Set<Drop> findDropsFromEntity(@Nonnull LivingEntity entity) {
        for (MobDrop mobDrop : this.getMobDrops()) {
            if (!mobDrop.isAllMobs() && entity.getType() != mobDrop.getDropsFrom() || mobDrop.getEntityName() != null && entity.getCustomName() != null && !mobDrop.getEntityName().equals(entity.getCustomName()) || mobDrop.getEntityNbtTag() != null && entity.getPersistentDataContainer().getKeys().stream().noneMatch(key -> key.equals((Object)mobDrop.getEntityNbtTag()))) continue;
            return mobDrop.getDrops();
        }
        return null;
    }

    @Nonnull
    public Set<MobDrop> getMobDrops() {
        return this.mobDrops;
    }

    public boolean isUnitTest() {
        return this.unitTest;
    }

    @Nonnull
    public static SfMobDrops getInstance() {
        return instance;
    }

    private static void setInstance(SfMobDrops ins) {
        instance = ins;
    }
}

