/*
 * Decompiled with CFR 0.152.
 */
package dev.walshy.sfmobdrops.dough.updater;

import dev.walshy.sfmobdrops.dough.updater.PluginUpdater;
import dev.walshy.sfmobdrops.dough.updater.UpdaterTask;
import dev.walshy.sfmobdrops.dough.versions.Version;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

abstract class AbstractPluginUpdater<V extends Version>
implements PluginUpdater<V> {
    private final Plugin plugin;
    private final File file;
    private int connectionTimeout = 9000;
    protected final V currentVersion;
    protected final CompletableFuture<V> latestVersion = new CompletableFuture();

    @ParametersAreNonnullByDefault
    protected AbstractPluginUpdater(Plugin plugin, File file, V currentVersion) {
        Validate.notNull((Object)plugin, (String)"The plugin cannot be null.");
        Validate.notNull((Object)file, (String)"The plugin file cannot be null.");
        Validate.notNull(currentVersion, (String)"The current version cannot be null.");
        this.plugin = plugin;
        this.file = file;
        this.currentVersion = currentVersion;
        this.prepareUpdateFolder();
    }

    private void prepareUpdateFolder() {
        File dir = new File("plugins/" + Bukkit.getUpdateFolder());
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        Validate.isTrue((timeout > 0 ? 1 : 0) != 0, (String)"Timeout must be positive.");
        this.connectionTimeout = timeout;
    }

    @Override
    @Nonnull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Nonnull
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    @Override
    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Override
    @Nonnull
    public V getCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    @Nonnull
    public CompletableFuture<V> getLatestVersion() {
        return this.latestVersion;
    }

    protected void scheduleAsyncUpdateTask(@Nonnull UpdaterTask<V> task) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, task);
    }
}

