/*
 * Decompiled with CFR 0.152.
 */
package dev.walshy.sfmobdrops;

import dev.walshy.sfmobdrops.Constants;
import dev.walshy.sfmobdrops.Drop;
import dev.walshy.sfmobdrops.Guis;
import dev.walshy.sfmobdrops.MobDropsCommand;
import dev.walshy.sfmobdrops.bstats.bukkit.Metrics;
import dev.walshy.sfmobdrops.dough.updater.GitHubBuildsUpdater;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SfMobDrops
extends JavaPlugin
implements Listener {
    private static SfMobDrops instance;
    private final Set<Drop> drops = new HashSet<Drop>();

    public void onEnable() {
        SfMobDrops.setInstance(this);
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        if (this.getConfig().getBoolean("settings.autoUpdate", true) && this.getDescription().getVersion().startsWith("DEV - ")) {
            new GitHubBuildsUpdater((Plugin)this, this.getFile(), "WalshyDev/SFMobDrops/main").start();
        }
        new Metrics(this, 11950);
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Guis(), (Plugin)this);
        this.getCommand("mobdrops").setExecutor((CommandExecutor)new MobDropsCommand());
    }

    public void onDisable() {
        SfMobDrops.setInstance(null);
    }

    protected void loadConfig() {
        HashSet<Drop> newSet = new HashSet<Drop>();
        List list = this.getConfig().getList("drops");
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Map map : list) {
            if (!this.validateArguments(map)) continue;
            EntityType type = this.entityFromString((String)map.get("entity"));
            String slimefunId = (String)map.get("slimefunItem");
            double chance = this.getDouble(map.get("chance"));
            String entityName = (String)map.get("name");
            String nbtTag = (String)map.get("nbtTag");
            int amount = map.get("amount") == null ? 1 : (Integer)map.get("amount");
            newSet.add(new Drop(type, slimefunId, chance, entityName, nbtTag, amount));
        }
        this.drops.clear();
        this.drops.addAll(newSet);
        this.getLogger().info("Loaded in " + this.drops.size() + " drops!");
    }

    @EventHandler
    public void onMobDeath(@Nonnull EntityDeathEvent e) {
        SlimefunItem item;
        Drop drop = this.findDropFromEntity(e.getEntity());
        if (drop != null && ThreadLocalRandom.current().nextDouble(100.0) <= drop.getChance() && (item = SlimefunItem.getById((String)drop.getSlimefunId())) != null && !item.isDisabledIn(e.getEntity().getWorld())) {
            ItemStack dropping = item.getItem().clone();
            dropping.setAmount(drop.getAmount());
            e.getDrops().add(dropping);
        }
    }

    private boolean validateArguments(@Nonnull Map<String, Object> map) {
        int amount;
        String entity = (String)map.get("entity");
        String sfItem = (String)map.get("slimefunItem");
        double chance = this.getDouble(map.get("chance"));
        String nbtTag = (String)map.get("nbtTag");
        int n = amount = map.get("amount") == null ? 1 : (Integer)map.get("amount");
        if (entity == null || sfItem == null) {
            this.getLogger().warning("Required property missing! 'entity', 'slimefunItem' and 'chance' are required!");
            return false;
        }
        if (!Constants.CONSTANT.matcher(entity).matches()) {
            this.getLogger().warning("Entity should be in SCREAMING_SNAKE_CASE!");
            return false;
        }
        if (!Constants.CONSTANT.matcher(sfItem).matches()) {
            this.getLogger().warning("Slimefun ID should be in SCREAMING_SNAKE_CASE!");
            return false;
        }
        if (chance < 1.0 || chance > 100.0) {
            this.getLogger().warning("Chance is not a valid value! It needs to be between 0-100");
            return false;
        }
        if (nbtTag != null && !Constants.NAMESPACE.matcher(nbtTag).matches()) {
            this.getLogger().warning("The NBT Tag need to be in snake_case!");
            return false;
        }
        if (amount < 1 || amount > 64) {
            this.getLogger().warning("Amount needs to be between 0-64!");
            return false;
        }
        if (this.entityFromString(entity) == null) {
            this.getLogger().warning("Invalid entity type value! Given: " + entity + " - valid values here: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/entity/EntityType.html");
            return false;
        }
        if (SlimefunItem.getById((String)sfItem) == null) {
            this.getLogger().warning("Invalid Slimefun Item ID! Given: " + sfItem + " - valid values can be found here: https://sf-items.walshy.dev/");
            return false;
        }
        return true;
    }

    @Nullable
    private EntityType entityFromString(@Nonnull String str) {
        try {
            return EntityType.valueOf((String)str);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().log(Level.WARNING, "Invalid Entity Type given! {0} is not valid!", str);
            return null;
        }
    }

    @Nullable
    private Drop findDropFromEntity(@Nonnull LivingEntity entity) {
        for (Drop drop : this.drops) {
            if (entity.getType() != drop.getDropsFrom() || drop.getEntityName() != null && entity.getCustomName() != null && !Constants.color(drop.getEntityName()).equals(entity.getCustomName()) || drop.getEntityNbtTag() != null && entity.getPersistentDataContainer().getKeys().stream().noneMatch(key -> key.toString().equals(drop.getEntityNbtTag()))) continue;
            return drop;
        }
        return null;
    }

    private double getDouble(@Nonnull Object obj) {
        return obj instanceof Integer ? (double)((Integer)obj).intValue() : (Double)obj;
    }

    @Nonnull
    public Set<Drop> getDrops() {
        return this.drops;
    }

    @Nonnull
    public static SfMobDrops getInstance() {
        return instance;
    }

    private static void setInstance(SfMobDrops ins) {
        instance = ins;
    }
}

