/*
 * Decompiled with CFR 0.152.
 */
package dev.walshy.sfmobdrops;

import dev.walshy.sfmobdrops.Constants;
import dev.walshy.sfmobdrops.Drop;
import dev.walshy.sfmobdrops.SfMobDrops;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class Guis
implements Listener {
    private static final String TITLE = ChatColor.DARK_PURPLE + "Mob Drops";

    protected Guis() {
    }

    public static void openMobDropList(Player player) {
        Set<Drop> drops = SfMobDrops.getInstance().getDrops();
        int size = (drops.size() + 8) / 9 * 9;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)TITLE);
        for (Drop drop : drops) {
            SlimefunItem item = drop.getSlimefunItem();
            if (item == null) continue;
            ItemStack is = new ItemStack(Guis.getMaterialForMob(drop.getDropsFrom()));
            ItemMeta im = is.getItemMeta();
            int amount = drop.getAmount();
            im.setDisplayName(ChatColor.GRAY + "" + amount + "x " + item.getItemName());
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + "Drops from " + Guis.getEntity(drop.getDropsFrom()));
            lore.add("");
            lore.add(ChatColor.LIGHT_PURPLE + "" + drop.getChance() + "% " + ChatColor.GRAY + "chance");
            if (drop.getEntityName() != null) {
                lore.add(ChatColor.GRAY + "Requires name: " + Constants.color(drop.getEntityName()));
            }
            if (drop.getEntityNbtTag() != null) {
                lore.add(ChatColor.GRAY + "Requires tag: " + ChatColor.LIGHT_PURPLE + drop.getEntityNbtTag());
            }
            im.setLore(lore);
            is.setItemMeta(im);
            inv.addItem(new ItemStack[]{is});
        }
        player.openInventory(inv);
    }

    private static Material getMaterialForMob(@Nonnull EntityType type) {
        if (type == EntityType.ENDER_DRAGON) {
            return Material.DRAGON_HEAD;
        }
        if (type == EntityType.ZOMBIE) {
            return Material.ZOMBIE_HEAD;
        }
        if (type == EntityType.CREEPER) {
            return Material.CREEPER_HEAD;
        }
        Material mat = Material.getMaterial((String)(type + "_SPAWN_EGG"));
        if (mat != null) {
            return mat;
        }
        return Material.SPAWNER;
    }

    private static String getEntity(@Nonnull EntityType type) {
        return ChatColor.LIGHT_PURPLE + Guis.capitalise(type.name().charAt(0) + type.name().substring(1).replace('_', ' ').toLowerCase(Locale.ROOT));
    }

    private static String capitalise(String str) {
        if (str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch == ' ') {
                capitalizeNext = true;
                continue;
            }
            if (!capitalizeNext) continue;
            chars[i] = Character.toTitleCase(ch);
            capitalizeNext = false;
        }
        return new String(chars);
    }

    @EventHandler
    public void onInvClick(@Nonnull InventoryClickEvent e) {
        if (e.getView().getTitle().equals(TITLE)) {
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
        }
    }
}

