/*
 * Decompiled with CFR 0.152.
 */
package dev.walshy.sfmobdrops.cscorelib2.updater;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.walshy.sfmobdrops.cscorelib2.updater.UpdateInfo;
import dev.walshy.sfmobdrops.cscorelib2.updater.Updater;
import dev.walshy.sfmobdrops.cscorelib2.updater.UpdaterTask;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import lombok.NonNull;
import org.bukkit.plugin.Plugin;

public class BukkitUpdater
implements Updater {
    private static final String API_URL = "https://api.curseforge.com/servermods/files?projectIds=";
    private static final String[] DEV_KEYWORDS = new String[]{"DEV", "EXPERIMENTAL", "BETA", "ALPHA", "UNFINISHED"};
    private final Plugin plugin;
    private final File file;
    private final int id;
    private Thread thread;
    private String localVersion;
    protected int timeout = 8000;

    public BukkitUpdater(@NonNull Plugin plugin, @NonNull File file, int id) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.plugin = plugin;
        this.id = id;
        this.file = file;
        this.localVersion = plugin.getDescription().getVersion();
    }

    @Override
    public void start() {
        for (String dev : DEV_KEYWORDS) {
            if (!this.localVersion.contains(dev)) continue;
            this.plugin.getLogger().log(Level.WARNING, " ");
            this.plugin.getLogger().log(Level.WARNING, "################## - DEVELOPMENT BUILD - ##################");
            this.plugin.getLogger().log(Level.WARNING, "You appear to be using an experimental build of {0}", this.plugin.getName());
            this.plugin.getLogger().log(Level.WARNING, "Version {0}", this.localVersion);
            this.plugin.getLogger().log(Level.WARNING, " ");
            this.plugin.getLogger().log(Level.WARNING, "Auto-Updates have been disabled. Use at your own risk!");
            this.plugin.getLogger().log(Level.WARNING, " ");
            return;
        }
        this.localVersion = this.localVersion.toLowerCase(Locale.ROOT);
        this.prepareUpdateFolder();
        try {
            URL url = new URL(API_URL + this.id);
            this.plugin.getServer().getScheduler().runTask(this.plugin, () -> {
                this.thread = new Thread((Runnable)new UpdaterTask(this, url){

                    @Override
                    public boolean hasUpdate(String localVersion, String remoteVersion) {
                        if (localVersion.equals(remoteVersion)) {
                            return false;
                        }
                        String[] localSplit = localVersion.split("\\.");
                        String[] remoteSplit = remoteVersion.split("\\.");
                        for (int i = 0; i < remoteSplit.length; ++i) {
                            if (localSplit.length - 1 < i) {
                                return true;
                            }
                            if (Integer.parseInt(localSplit[i]) > Integer.parseInt(remoteSplit[i])) {
                                return false;
                            }
                            if (Integer.parseInt(remoteSplit[i]) <= Integer.parseInt(localSplit[i])) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public UpdateInfo parse(String result) throws MalformedURLException {
                        JsonArray array = (JsonArray)new JsonParser().parse(result);
                        if (array.size() == 0) {
                            BukkitUpdater.this.plugin.getLogger().log(Level.WARNING, "The Auto-Updater could not connect to dev.bukkit.org, is it down?");
                            return null;
                        }
                        JsonObject latest = array.get(array.size() - 1).getAsJsonObject();
                        URL download = new URL(latest.get("downloadUrl").getAsString());
                        String remoteVersion = latest.getAsJsonObject().get("name").getAsString();
                        remoteVersion = remoteVersion.toLowerCase(Locale.ROOT);
                        return new UpdateInfo(download, remoteVersion);
                    }
                }, "Updater Thread");
                this.thread.start();
            });
        }
        catch (MalformedURLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Auto-Updater URL is malformed", e);
        }
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getLocalVersion() {
        return this.localVersion;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

