/*
 * Decompiled with CFR 0.152.
 */
package dev.walshy.sfmobdrops.cscorelib2.updater;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.walshy.sfmobdrops.cscorelib2.updater.UpdateInfo;
import dev.walshy.sfmobdrops.cscorelib2.updater.Updater;
import dev.walshy.sfmobdrops.cscorelib2.updater.UpdaterTask;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import lombok.NonNull;
import org.bukkit.plugin.Plugin;

public class GitHubBuildsUpdater
implements Updater {
    private static final String API_URL = "https://thebusybiscuit.github.io/builds/";
    private final Plugin plugin;
    private final File file;
    private final String repository;
    private final String prefix;
    private String localVersion;
    protected int timeout = 10000;

    public GitHubBuildsUpdater(@NonNull Plugin plugin, @NonNull File file, @NonNull String repo) {
        this(plugin, file, repo, "DEV - ");
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (repo == null) {
            throw new NullPointerException("repo is marked non-null but is null");
        }
    }

    public GitHubBuildsUpdater(@NonNull Plugin plugin, @NonNull File file, @NonNull String repo, @NonNull String prefix) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (repo == null) {
            throw new NullPointerException("repo is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.plugin = plugin;
        this.file = file;
        this.repository = repo;
        this.prefix = prefix;
        this.localVersion = this.extractBuild(plugin.getDescription().getVersion());
        this.prepareUpdateFolder();
    }

    private String extractBuild(String version) {
        if (version.startsWith(this.prefix)) {
            return version.substring(this.prefix.length()).split(" ")[0];
        }
        throw new IllegalArgumentException("Not a valid Development-Build Version: " + version);
    }

    @Override
    public void start() {
        try {
            URL versionsURL = new URL(API_URL + this.getRepository() + "/builds.json");
            this.plugin.getServer().getScheduler().runTask(this.plugin, () -> {
                Thread thread = new Thread((Runnable)new UpdaterTask(this, versionsURL){

                    @Override
                    public boolean hasUpdate(String localVersion, String remoteVersion) {
                        return Integer.parseInt(remoteVersion) > Integer.parseInt(localVersion);
                    }

                    @Override
                    public UpdateInfo parse(String result) throws MalformedURLException {
                        JsonObject json = (JsonObject)new JsonParser().parse(result);
                        if (json == null) {
                            GitHubBuildsUpdater.this.plugin.getLogger().log(Level.WARNING, "The Auto-Updater could not connect to github.io, is it down?");
                            return null;
                        }
                        String remoteVersion = String.valueOf(json.get("last_successful").getAsInt());
                        URL downloadURL = new URL(GitHubBuildsUpdater.API_URL + GitHubBuildsUpdater.this.getRepository() + "/" + GitHubBuildsUpdater.this.getRepository().split("/")[1] + "-" + remoteVersion + ".jar");
                        return new UpdateInfo(downloadURL, remoteVersion);
                    }
                }, "Updater Thread");
                thread.start();
            });
        }
        catch (MalformedURLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Auto-Updater URL is malformed", e);
        }
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public String getRepository() {
        return this.repository;
    }

    @Override
    public String getLocalVersion() {
        return this.localVersion;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

