/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.SFCalc;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CalcExecutor
implements CommandExecutor {
    private final SFCalc plugin;

    public CalcExecutor(SFCalc plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        int amount;
        if (args.length > 2) {
            return false;
        }
        if (args.length == 0) {
            if (sender instanceof Player) {
                this.openGUI((Player)sender);
                return true;
            }
            return false;
        }
        String reqItem = args[0];
        if (args.length == 1) {
            amount = 1;
        } else if (PatternUtils.NUMERIC.matcher(args[1]).matches()) {
            amount = Integer.parseInt(args[1]);
        } else {
            sender.sendMessage(ChatColor.RED + "That's not a number!");
            return true;
        }
        reqItem = reqItem.toUpperCase();
        SlimefunItem item = SlimefunItem.getByID((String)reqItem);
        if (item == null) {
            sender.sendMessage(ChatColor.RED + "That item was not found.");
            return true;
        }
        this.printResults(this.calculate(item), sender, s, item, amount);
        return true;
    }

    void printResults(List<String> results, CommandSender sender, String s, SlimefunItem item, int amount) {
        HashSet<String> resultSet = new HashSet<String>(results);
        sender.sendMessage(String.format(this.plugin.headerString, CalcExecutor.capitalize(ChatColor.stripColor((String)item.getItemName()))));
        if (s.equalsIgnoreCase("sfcalc")) {
            for (String name : resultSet) {
                sender.sendMessage(this.format(this.plugin.amountString, Collections.frequency(results, name) * amount, CalcExecutor.capitalize(name.replace("_", " ").toLowerCase())));
            }
        } else if (sender instanceof Player) {
            PlayerInventory inv = ((Player)sender).getInventory();
            ArrayList<String> sfInv = new ArrayList<String>();
            for (ItemStack i : inv.getContents()) {
                SlimefunItem sfItem;
                if (i == null || (sfItem = SlimefunItem.getByItem((ItemStack)i)) == null) continue;
                sfInv.add(sfItem.getItemName());
            }
            for (String name : resultSet) {
                sender.sendMessage(this.format(this.plugin.amountString, Collections.frequency(results, name) * amount - Collections.frequency(sfInv, name), CalcExecutor.capitalize(name.replace("_", " "))));
            }
        } else {
            sender.sendMessage("You have to be a player to send this message!");
        }
    }

    List<String> calculate(SlimefunItem item) {
        ArrayList<String> result = new ArrayList<String>();
        for (ItemStack i : item.getRecipe()) {
            if (i == null) continue;
            SlimefunItem ingredient = SlimefunItem.getByItem((ItemStack)i);
            if (ingredient == null) {
                result.add(i.getType().toString());
                continue;
            }
            if (this.plugin.blacklistedIds.contains(ingredient.getID().toLowerCase())) {
                result.add(ChatColor.stripColor((String)ingredient.getItemName()));
                continue;
            }
            if (!this.plugin.blacklistedRecipes.contains(ingredient.getRecipeType())) {
                List<String> subitems = this.calculate(ingredient);
                result.addAll(subitems);
                continue;
            }
            result.add(ChatColor.stripColor((String)ingredient.getItemName()));
        }
        return result;
    }

    private static String capitalize(String s) {
        StringBuilder capped = new StringBuilder();
        String string = s.trim();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0) {
                capped.append(Character.toUpperCase(c));
                continue;
            }
            c = Character.toLowerCase(c);
            if (string.charAt(i - 1) == ' ') {
                c = Character.toUpperCase(c);
            }
            capped.append(c);
        }
        return capped.toString();
    }

    private void openGUI(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)SFCalc.getSlots(SlimefunPlugin.getRegistry().getCategories().size()), (String)"Choose a Category");
        for (Category category : SlimefunPlugin.getRegistry().getCategories()) {
            inv.addItem(new ItemStack[]{category.getItem(player)});
        }
        player.openInventory(inv);
    }

    private String format(String s, int a, String i) {
        return s.replace("%d", Integer.toString(a)).replace("%s", i);
    }
}

