/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.SFCalc;
import io.github.seggan.sfcalc.SFCalcMetrics;
import io.github.seggan.sfcalc.StringRegistry;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class CalcCommand
implements TabExecutor {
    private static final Set<String> ids = new HashSet<String>();
    private final SFCalc plugin;

    public CalcCommand(SFCalc pl) {
        this.plugin = pl;
    }

    public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String alias, @Nonnull String[] args) {
        SFCalc.REPORTER.executeOrElseReport(() -> {
            long amount;
            StringRegistry registry = this.plugin.getStringRegistry();
            if (args.length > 2 || args.length == 0) {
                return;
            }
            String reqItem = args[0];
            if (args.length == 1) {
                amount = 1L;
            } else {
                if (!CommonPatterns.NUMERIC.matcher(args[1]).matches()) {
                    sender.sendMessage(StringRegistry.format(registry.getNotANumberString(), new Object[0]));
                    return;
                }
                try {
                    amount = Long.parseLong(args[1]);
                    if (amount == 0L || amount > Integer.MAX_VALUE) {
                        sender.sendMessage(StringRegistry.format(registry.getInvalidNumberString(), new Object[0]));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(StringRegistry.format(registry.getInvalidNumberString(), new Object[0]));
                    return;
                }
            }
            SlimefunItem item = SlimefunItem.getById((String)reqItem.toUpperCase(Locale.ROOT));
            if (item == null) {
                sender.sendMessage(StringRegistry.format(registry.getNoItemString(), new Object[0]));
                return;
            }
            SFCalcMetrics.addItemSearched(item.getItemName());
            this.plugin.getCalc().printResults(sender, item, amount, false);
        });
        return true;
    }

    public List<String> onTabComplete(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String alias, @Nonnull String[] args) {
        ArrayList<String> tabs = new ArrayList<String>();
        SFCalc.REPORTER.executeOrElseReport(() -> {
            if (ids.isEmpty()) {
                for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
                    if (item.isHidden()) continue;
                    ids.add(item.getId().toLowerCase(Locale.ROOT));
                }
            }
            if (args.length == 1) {
                for (String id : ids) {
                    if (!id.contains(args[0].toLowerCase(Locale.ROOT))) continue;
                    tabs.add(id);
                }
            }
        });
        return tabs;
    }
}

