/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.CalcCommand;
import io.github.seggan.sfcalc.Calculator;
import io.github.seggan.sfcalc.SFCalcMetrics;
import io.github.seggan.sfcalc.StringRegistry;
import io.github.seggan.sfcalc.errorreporter.ErrorReporter;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SFCalc
extends JavaPlugin
implements Listener {
    public static ErrorReporter REPORTER;
    private static SFCalc instance;
    private final Set<RecipeType> blacklistedRecipes = new HashSet<RecipeType>();
    private final Set<String> blacklistedIds = new HashSet<String>();
    private Calculator calculator;
    private StringRegistry stringRegistry;

    public void onEnable() {
        instance = this;
        new BlobBuildUpdater((Plugin)this, this.getFile(), "SFCalc").start();
        REPORTER = new ErrorReporter("Seggan", "SFCalc", () -> "SFCalc " + this.getDescription().getVersion() + "\nSlimefun " + Slimefun.getVersion() + "\nMinecraft " + Slimefun.getMinecraftVersion().getName());
        REPORTER.preSend(obj -> !this.getDescription().getVersion().equals("UNOFFICIAL"));
        REPORTER.setOn(this.getConfig().getBoolean("error-reports", true));
        REPORTER.executeOrElseReport(() -> {
            new SFCalcMetrics(this);
            this.stringRegistry = new StringRegistry(this.getConfig(), new File(this.getDataFolder(), "config.yml"));
            this.calculator = new Calculator(this);
            this.blacklistedRecipes.add(RecipeType.ORE_WASHER);
            this.blacklistedRecipes.add(RecipeType.GEO_MINER);
            this.blacklistedRecipes.add(RecipeType.GOLD_PAN);
            this.blacklistedRecipes.add(RecipeType.MOB_DROP);
            this.blacklistedRecipes.add(RecipeType.BARTER_DROP);
            this.blacklistedRecipes.add(RecipeType.ORE_CRUSHER);
            this.blacklistedRecipes.add(RecipeType.NULL);
            this.blacklistedIds.add("UU_MATTER");
            this.blacklistedIds.add("SILICON");
            this.blacklistedIds.add("FALLEN_METEOR");
            this.blacklistedIds.add("RUBBER");
            this.blacklistedIds.add("VOID_BIT");
            if (this.getConfig().getBoolean("options.use-carbon-instead-of-coal", true)) {
                this.blacklistedIds.add("CARBON");
            }
            CalcCommand calcCommand = new CalcCommand(this);
            this.getCommand("sfcalc").setExecutor((CommandExecutor)calcCommand);
            this.getCommand("sfcalc").setTabCompleter((TabCompleter)calcCommand);
        });
    }

    public void onDisable() {
        instance = null;
    }

    public Calculator getCalc() {
        return this.calculator;
    }

    public Set<RecipeType> getBlacklistedRecipes() {
        return this.blacklistedRecipes;
    }

    public Set<String> getBlacklistedIds() {
        return this.blacklistedIds;
    }

    public Calculator getCalculator() {
        return this.calculator;
    }

    public StringRegistry getStringRegistry() {
        return this.stringRegistry;
    }
}

