/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc.infinitylib.machines;

import io.github.seggan.sfcalc.infinitylib.machines.MachineLayout;
import io.github.seggan.sfcalc.infinitylib.machines.MenuBlockPreset;
import io.github.seggan.sfcalc.infinitylib.machines.TickingMenuBlock;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;

@ParametersAreNonnullByDefault
public abstract class AbstractMachineBlock
extends TickingMenuBlock
implements EnergyNetComponent {
    protected static final ItemStack PROCESSING_ITEM = new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&aProcessing...", new String[0]);
    protected static final ItemStack NO_ENERGY_ITEM = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, "&cNot enough energy!", new String[0]);
    protected static final ItemStack NO_ROOM_ITEM = new CustomItemStack(Material.ORANGE_STAINED_GLASS_PANE, "&6Not enough room!", new String[0]);
    protected static final ItemStack OUTPUT_BORDER = new CustomItemStack(ChestMenuUtils.getOutputSlotTexture(), "&6Output", new String[0]);
    protected static final ItemStack INPUT_BORDER = new CustomItemStack(ChestMenuUtils.getInputSlotTexture(), "&9Input", new String[0]);
    protected static final ItemStack IDLE_ITEM = new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, "&8Idle", new String[0]);
    protected static final ChestMenu.MenuClickHandler EMPTY_CLICK_HANDLER = ChestMenuUtils.getEmptyClickHandler();
    protected static final ItemStack BACKGROUND_ITEM = ChestMenuUtils.getBackground();
    protected MachineLayout layout;
    protected int energyPerTick = -1;
    protected int energyCapacity = -1;

    public AbstractMachineBlock(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    protected void tick(Block b, BlockMenu menu) {
        if (this.getCharge(menu.getLocation()) < this.energyPerTick) {
            this.updateStatus(menu, NO_ENERGY_ITEM);
        } else if (this.process(b, menu)) {
            this.removeCharge(menu.getLocation(), this.energyPerTick);
        }
    }

    protected abstract boolean process(Block var1, BlockMenu var2);

    @Override
    protected void setup(MenuBlockPreset preset) {
        preset.drawBackground(OUTPUT_BORDER, this.layout.outputBorder());
        preset.drawBackground(INPUT_BORDER, this.layout.inputBorder());
        preset.drawBackground(BACKGROUND_ITEM, this.layout.background());
        preset.addItem(this.layout.statusSlot(), IDLE_ITEM, EMPTY_CLICK_HANDLER);
    }

    @Override
    protected final int[] getInputSlots() {
        return this.layout.inputSlots();
    }

    @Override
    protected final int[] getOutputSlots() {
        return this.layout.outputSlots();
    }

    public final int getCapacity() {
        return this.energyCapacity;
    }

    @Nonnull
    public final EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public final void register(@Nonnull SlimefunAddon addon) {
        if (this.energyPerTick == -1) {
            throw new IllegalStateException("You must call .energyPerTick() before registering!");
        }
        if (this.energyCapacity == -1) {
            this.energyCapacity = this.energyPerTick * 2;
        }
        if (this.layout == null) {
            this.layout = MachineLayout.DEFAULT;
        }
        super.register(addon);
    }

    protected final void updateStatus(BlockMenu menu, ItemStack item) {
        int slot = this.layout.statusSlot();
        if (menu.getItemInSlot(slot).getType() != item.getType()) {
            menu.replaceExistingItem(this.layout.statusSlot(), item);
        }
    }

    protected final boolean quickPush(ItemStack item, BlockMenu menu) {
        int amount = item.getAmount();
        Material type = item.getType();
        PersistentDataContainer container = null;
        boolean hasItemMeta = item.hasItemMeta();
        for (int slot : this.getOutputSlots()) {
            ItemStack target = menu.getItemInSlot(slot);
            if (target == null) {
                menu.replaceExistingItem(slot, item, false);
                return true;
            }
            if (type != target.getType()) continue;
            int targetAmount = target.getAmount();
            int max = target.getMaxStackSize() - targetAmount;
            if (max <= 0) continue;
            if (hasItemMeta) {
                if (target.hasItemMeta()) {
                    PersistentDataContainer other;
                    if (container == null) {
                        container = item.getItemMeta().getPersistentDataContainer();
                    }
                    if (!container.equals(other = target.getItemMeta().getPersistentDataContainer())) {
                        continue;
                    }
                }
            } else if (target.hasItemMeta()) continue;
            int push = Math.min(amount, max);
            target.setAmount(push + targetAmount);
            if (push == amount) {
                return true;
            }
            amount -= push;
        }
        return amount < item.getAmount();
    }

    @Nonnull
    public AbstractMachineBlock layout(MachineLayout layout) {
        this.layout = layout;
        return this;
    }

    @Nonnull
    public AbstractMachineBlock energyPerTick(int energyPerTick) {
        this.energyPerTick = energyPerTick;
        return this;
    }

    @Nonnull
    public AbstractMachineBlock energyCapacity(int energyCapacity) {
        this.energyCapacity = energyCapacity;
        return this;
    }
}

