/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc.infinitylib.machines;

import io.github.seggan.sfcalc.infinitylib.core.AbstractAddon;
import io.github.seggan.sfcalc.infinitylib.machines.AbstractMachineBlock;
import io.github.seggan.sfcalc.infinitylib.machines.MachineBlockRecipe;
import io.github.seggan.sfcalc.infinitylib.machines.MachineInput;
import io.github.seggan.sfcalc.infinitylib.machines.MachineRecipeType;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public final class MachineBlock
extends AbstractMachineBlock {
    private final List<MachineBlockRecipe> recipes = new ArrayList<MachineBlockRecipe>();
    private int ticksPerOutput = -1;

    public MachineBlock(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Nonnull
    public MachineBlock ticksPerOutput(int ticks) {
        if (ticks < 1) {
            throw new IllegalArgumentException("Ticks Per Output must be at least 1!");
        }
        this.ticksPerOutput = ticks;
        return this;
    }

    public void preRegister() {
        if (this.ticksPerOutput == -1) {
            throw new IllegalStateException("You must call .ticksPerOutput() before registering!");
        }
        super.preRegister();
    }

    @Override
    protected boolean process(Block b, BlockMenu menu) {
        if (AbstractAddon.slimefunTickCount() % this.ticksPerOutput != 0) {
            return true;
        }
        HashMap<String, MachineInput> map = new HashMap<String, MachineInput>(2, 1.0f);
        for (int slot : this.getInputSlots()) {
            ItemStack item = menu.getItemInSlot(slot);
            if (item == null) continue;
            String string = Slimefun.getItemDataService().getItemData(item).orElseGet(() -> item.getType().name());
            map.compute(string, (str, input) -> input == null ? new MachineInput(item) : input.add(item));
        }
        Object object = this.recipes.iterator();
        while (object.hasNext()) {
            MachineBlockRecipe recipe = (MachineBlockRecipe)object.next();
            if (!recipe.check(map)) continue;
            if (this.quickPush(recipe.output.clone(), menu)) {
                recipe.consume(map);
                this.updateStatus(menu, PROCESSING_ITEM);
                return true;
            }
            this.updateStatus(menu, NO_ROOM_ITEM);
            return false;
        }
        this.updateStatus(menu, IDLE_ITEM);
        return false;
    }

    public MachineBlock addRecipe(ItemStack output, ItemStack ... inputs) {
        if (inputs.length == 0) {
            throw new IllegalArgumentException("Cannot add recipe with no input!");
        }
        MachineBlockRecipe recipe = new MachineBlockRecipe(output);
        for (ItemStack item : inputs) {
            recipe.add(item);
        }
        this.recipes.add(recipe);
        return this;
    }

    public MachineBlock subscribe(MachineRecipeType type) {
        type.subscribe((ItemStack[] inputs, ItemStack outputs) -> this.addRecipe((ItemStack)outputs, (ItemStack)inputs));
        return this;
    }
}

