/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.infinitylib.core.AddonConfig;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;

public final class StringRegistry {
    private final Pattern percentPattern = Pattern.compile("(%s|%d)");
    private final String headerString;
    private final String headerAmountString;
    private final String stackString;
    private final String amountString;
    private final String neededString;
    private final String noItemString;
    private final String notANumberString;
    private final String tooManyCategoriesString;
    private final String tooManyItemsString;
    private final String notAPlayerString;
    private final String invalidNumberString;

    StringRegistry(AddonConfig config) {
        this.headerString = this.reformat(config, "header-string", 1);
        this.headerAmountString = this.reformat(config, "header-amount-string", 2, 1);
        this.stackString = this.reformat(config, "stack-string", 1, 2, 3, 4);
        this.amountString = this.reformat(config, "amount-string", 2, 1);
        this.neededString = this.reformat(config, "needed-string", 2, 1);
        this.noItemString = config.getString("no-item-string");
        this.notANumberString = config.getString("not-a-number-string");
        this.tooManyCategoriesString = config.getString("category-error-string");
        this.tooManyItemsString = config.getString("item-error-string");
        this.notAPlayerString = config.getString("not-a-player-string");
        this.invalidNumberString = config.getString("invalid-number-string");
        config.save();
    }

    @Nonnull
    public static String format(@Nonnull String formatString, Object ... objects) {
        Validate.notNull((Object)formatString);
        Validate.noNullElements((Object[])objects);
        String finalString = formatString;
        for (int i = 0; i < objects.length; ++i) {
            finalString = finalString.replace("%" + (i + 1), objects[i].toString());
        }
        return ChatColors.color((String)finalString);
    }

    private String reformat(AddonConfig config, String key, int ... numbers) {
        String val = config.getString(key);
        AtomicInteger i = new AtomicInteger();
        String formatted = this.percentPattern.matcher(val).replaceAll(matchResult -> "%" + numbers[i.getAndIncrement()]);
        if (i.get() == numbers.length) {
            config.set(key, formatted);
            return formatted;
        }
        return val;
    }

    public Pattern getPercentPattern() {
        return this.percentPattern;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public String getHeaderAmountString() {
        return this.headerAmountString;
    }

    public String getStackString() {
        return this.stackString;
    }

    public String getAmountString() {
        return this.amountString;
    }

    public String getNeededString() {
        return this.neededString;
    }

    public String getNoItemString() {
        return this.noItemString;
    }

    public String getNotANumberString() {
        return this.notANumberString;
    }

    public String getTooManyCategoriesString() {
        return this.tooManyCategoriesString;
    }

    public String getTooManyItemsString() {
        return this.tooManyItemsString;
    }

    public String getNotAPlayerString() {
        return this.notAPlayerString;
    }

    public String getInvalidNumberString() {
        return this.invalidNumberString;
    }
}

