/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.SFCalc;
import io.github.seggan.sfcalc.SFCalcMetrics;
import io.github.seggan.sfcalc.StringRegistry;
import io.github.seggan.sfcalc.infinitylib.commands.SubCommand;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class CalcCommand
extends SubCommand {
    private static final List<String> ids = new ArrayList<String>();
    private final SFCalc plugin;

    public CalcCommand(SFCalc pl) {
        super("calc", "Calculates the resources needed for a given item", false);
        this.plugin = pl;
    }

    @Override
    public void execute(@Nonnull CommandSender sender, @Nonnull String[] args) {
        SFCalc.REPORTER.executeOrElseReport(() -> {
            long amount;
            StringRegistry registry = this.plugin.getStringRegistry();
            if (args.length > 2 || args.length == 0) {
                return;
            }
            String reqItem = args[0];
            if (args.length == 1) {
                amount = 1L;
            } else {
                if (!CommonPatterns.NUMERIC.matcher(args[1]).matches()) {
                    sender.sendMessage(StringRegistry.format(registry.getNotANumberString(), new Object[0]));
                    return;
                }
                try {
                    amount = Long.parseLong(args[1]);
                    if (amount == 0L || amount > Integer.MAX_VALUE) {
                        sender.sendMessage(StringRegistry.format(registry.getInvalidNumberString(), new Object[0]));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(StringRegistry.format(registry.getInvalidNumberString(), new Object[0]));
                    return;
                }
            }
            SlimefunItem item = SlimefunItem.getById((String)reqItem.toUpperCase(Locale.ROOT));
            if (item == null) {
                sender.sendMessage(StringRegistry.format(registry.getNoItemString(), new Object[0]));
                return;
            }
            SFCalcMetrics.addItemSearched(item.getItemName());
            this.plugin.getCalc().printResults(sender, item, amount, false);
        });
    }

    @Override
    public void complete(@Nonnull CommandSender sender, @Nonnull String[] args, @Nonnull List<String> tabs) {
        SFCalc.REPORTER.executeOrElseReport(() -> {
            if (ids.isEmpty()) {
                for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
                    ids.add(item.getId().toLowerCase(Locale.ROOT));
                }
            }
            if (args.length == 1) {
                StringUtil.copyPartialMatches((String)args[0], ids, (Collection)tabs);
            }
        });
    }
}

