/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc.errorreporter;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.seggan.sfcalc.errorreporter.ReportException;
import io.github.seggan.sfcalc.errorreporter.ThrowingRunnable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorReporter {
    private static final URL URL;
    private final String user;
    private final String repo;
    private final Supplier<String> versionSupplier;
    private Predicate<JsonObject> preSend;

    public ErrorReporter(@NotNull String user, @NotNull String repo, @NotNull Supplier<String> versionSupplier) {
        this.user = user;
        this.repo = repo;
        this.versionSupplier = versionSupplier;
    }

    public static void main(String[] args) {
        new ErrorReporter("", "", () -> "No version").sendError(new IOException(), false);
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public void sendError(@NotNull Throwable throwable, boolean rethrow) throws ReportException {
        try {
            HttpURLConnection connection = (HttpURLConnection)URL.openConnection();
            JsonObject object = new JsonObject();
            String version = this.versionSupplier.get();
            object.add("Version", new JsonPrimitive(version));
            try (StringWriter writer = new StringWriter();
                 PrintWriter printWriter = new PrintWriter(writer);){
                throwable.printStackTrace(printWriter);
                String asString = writer.toString();
                object.add("Error", new JsonPrimitive("```\n" + asString + "\n```"));
                object.add("Hashcode", new JsonPrimitive(Integer.toHexString(asString.hashCode()) + '-' + Integer.toHexString(version.hashCode())));
            }
            if (this.preSend != null && this.preSend.test(object)) {
                if (rethrow) {
                    ErrorReporter.sneakyThrow(throwable);
                }
                return;
            }
            String s = object.toString();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", Integer.toString(s.length()));
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/12.246");
            connection.setRequestProperty("User", this.user);
            connection.setRequestProperty("Repo", this.repo);
            connection.setRequestProperty("Version", "1");
            connection.getOutputStream().write(s.getBytes(StandardCharsets.UTF_8));
            connection.getOutputStream().flush();
            connection.connect();
            int code = connection.getResponseCode();
            switch (code) {
                case 500: {
                    throw new ReportException("Server error");
                }
                case 404: {
                    throw new ReportException("User/Repository not found");
                }
                case 410: {
                    throw new ReportException("Repository has issues disabled");
                }
                case 503: {
                    throw new ReportException("GitHub service down");
                }
                case 400: {
                    throw new ReportException("Bad request; maybe using wrong API version?");
                }
            }
            connection.disconnect();
        }
        catch (IOException e) {
            throw new ReportException(e);
        }
        if (rethrow) {
            ErrorReporter.sneakyThrow(throwable);
        }
    }

    public void sendError(@NotNull Throwable throwable) throws ReportException {
        this.sendError(throwable, true);
    }

    public void executeOrElseReport(@NotNull ThrowingRunnable runnable, boolean rethrow) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            this.sendError(e, rethrow);
        }
    }

    public void executeOrElseReport(@NotNull ThrowingRunnable runnable) {
        this.executeOrElseReport(runnable, true);
    }

    public ErrorReporter preSend(@Nullable Predicate<JsonObject> preSend) {
        this.preSend = preSend;
        return this;
    }

    static {
        try {
            URL = new URL("https://error-reports.seggan.workers.dev");
        }
        catch (MalformedURLException e) {
            ErrorReporter.sneakyThrow(e);
            throw null;
        }
    }
}

