/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc.infinitylib.core;

import io.github.seggan.sfcalc.infinitylib.InfinityLib;
import io.github.seggan.sfcalc.infinitylib.commands.AddonCommand;
import io.github.seggan.sfcalc.infinitylib.commands.ParentCommand;
import io.github.seggan.sfcalc.infinitylib.common.Scheduler;
import io.github.seggan.sfcalc.infinitylib.core.AddonConfig;
import io.github.seggan.sfcalc.infinitylib.core.Environment;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.GitHubBuildsUpdater;
import java.io.File;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public abstract class AbstractAddon
extends JavaPlugin
implements SlimefunAddon {
    private static AbstractAddon instance;
    private final GitHubBuildsUpdater updater;
    private final Environment environment;
    private final String githubUserName;
    private final String githubRepo;
    private final String autoUpdateBranch;
    private final String autoUpdateKey;
    private final String bugTrackerURL;
    private AddonCommand command;
    private AddonConfig config;
    private int slimefunTickCount;
    private boolean autoUpdatesEnabled;
    private boolean disabling;
    private boolean enabling;
    private boolean loading;

    public AbstractAddon(String githubUserName, String githubRepo, String autoUpdateBranch, String autoUpdateKey) {
        boolean official = this.getDescription().getVersion().matches("DEV - \\d+ \\(git \\w+\\)");
        this.updater = official ? new GitHubBuildsUpdater((Plugin)this, this.getFile(), githubUserName + "/" + githubRepo + "/" + autoUpdateBranch) : null;
        this.environment = Environment.LIVE;
        this.githubUserName = githubUserName;
        this.autoUpdateBranch = autoUpdateBranch;
        this.githubRepo = githubRepo;
        this.autoUpdateKey = autoUpdateKey;
        this.bugTrackerURL = "https://github.com/" + githubUserName + "/" + githubRepo + "/issues";
        this.validate();
    }

    protected AbstractAddon(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file, String githubUserName, String githubRepo, String autoUpdateBranch, String autoUpdateKey) {
        this(loader, description, dataFolder, file, githubUserName, githubRepo, autoUpdateBranch, autoUpdateKey, Environment.TESTING);
    }

    AbstractAddon(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file, String githubUserName, String githubRepo, String autoUpdateBranch, String autoUpdateKey, Environment environment) {
        super(loader, description, dataFolder, file);
        this.updater = null;
        this.environment = environment;
        this.githubUserName = githubUserName;
        this.autoUpdateBranch = autoUpdateBranch;
        this.githubRepo = githubRepo;
        this.autoUpdateKey = autoUpdateKey;
        this.bugTrackerURL = "https://github.com/" + githubUserName + "/" + githubRepo + "/issues";
        this.validate();
    }

    private void validate() {
        if (this.environment == Environment.LIVE && InfinityLib.PACKAGE.contains("mooy1.infinitylib")) {
            throw new IllegalStateException("You must relocate InfinityLib to your own package!");
        }
        String addonPackage = ((Object)((Object)this)).getClass().getPackage().getName();
        if (!addonPackage.contains(InfinityLib.ADDON_PACKAGE)) {
            throw new IllegalStateException("Shade and relocate your own InfinityLib!");
        }
        if (instance != null) {
            throw new IllegalStateException("Addon " + instance.getName() + " is already using this InfinityLib, Shade an relocate your own!");
        }
        if (!this.githubUserName.matches("[\\w-]+")) {
            throw new IllegalArgumentException("Invalid githubUserName");
        }
        if (!this.githubRepo.matches("[\\w-]+")) {
            throw new IllegalArgumentException("Invalid githubRepo");
        }
        if (!this.autoUpdateBranch.matches("[\\w-]+")) {
            throw new IllegalArgumentException("Invalid autoUpdateBranch");
        }
    }

    public final void onLoad() {
        if (this.loading) {
            throw new IllegalStateException(this.getName() + " is already loading! Do not call super.onLoad()!");
        }
        this.loading = true;
        try {
            this.load();
        }
        catch (RuntimeException e) {
            this.handle(e);
        }
        finally {
            this.loading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onEnable() {
        PluginCommand pluginCommand;
        if (this.enabling) {
            throw new IllegalStateException(this.getName() + " is already enabling! Do not call super.onEnable()!");
        }
        this.enabling = true;
        instance = this;
        boolean brokenConfig = false;
        try {
            this.config = new AddonConfig("config.yml");
        }
        catch (RuntimeException e) {
            brokenConfig = true;
            e.printStackTrace();
        }
        if (this.autoUpdateKey == null) {
            brokenConfig = true;
            this.handle(new IllegalStateException("Null auto update key"));
        } else if (this.autoUpdateKey.isEmpty()) {
            brokenConfig = true;
            this.handle(new IllegalStateException("Empty auto update key!"));
        } else if (!brokenConfig && !this.config.getDefaults().contains(this.autoUpdateKey, true)) {
            brokenConfig = true;
            this.handle(new IllegalStateException("Auto update key missing from the default config!"));
        }
        if (this.updater != null) {
            if (brokenConfig) {
                this.updater.start();
            } else if (this.config.getBoolean(this.autoUpdateKey)) {
                this.autoUpdatesEnabled = true;
                this.updater.start();
            }
        }
        if ((pluginCommand = this.getCommand(this.getName())) == null) {
            this.handle(new IllegalStateException("Command named '" + this.getName() + "' missing from plugin.yml!"));
        } else {
            this.command = new AddonCommand(pluginCommand);
        }
        Scheduler.repeat(Slimefun.getTickerTask().getTickRate(), () -> ++this.slimefunTickCount);
        try {
            this.enable();
        }
        catch (RuntimeException e) {
            this.handle(e);
        }
        finally {
            this.enabling = false;
        }
    }

    public final void onDisable() {
        if (this.disabling) {
            throw new IllegalStateException(this.getName() + " is already disabling! Do not call super.onDisable()!");
        }
        this.disabling = true;
        try {
            this.disable();
        }
        catch (RuntimeException e) {
            this.handle(e);
        }
        finally {
            this.disabling = false;
            instance = null;
            this.slimefunTickCount = 0;
            this.command = null;
            this.config = null;
        }
    }

    private void handle(RuntimeException e) {
        switch (this.environment) {
            case TESTING: {
                throw e;
            }
            case LIVE: {
                e.printStackTrace();
            }
        }
    }

    protected void load() {
    }

    protected abstract void enable();

    protected abstract void disable();

    @Nonnull
    protected final ParentCommand getCommand() {
        return this.command;
    }

    protected final boolean autoUpdatesEnabled() {
        return this.autoUpdatesEnabled;
    }

    @Nonnull
    public final JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nonnull
    public final String getBugTrackerURL() {
        return this.bugTrackerURL;
    }

    @Nonnull
    public final AddonConfig getConfig() {
        return this.config;
    }

    public final void reloadConfig() {
        this.config.reload();
    }

    public final void saveConfig() {
        this.config.save();
    }

    public final void saveDefaultConfig() {
    }

    @Nonnull
    public final String getPluginVersion() {
        return this.getDescription().getVersion();
    }

    public final boolean hasDependency(String dependency) {
        return super.hasDependency(dependency);
    }

    @Nonnull
    public static <T extends AbstractAddon> T instance() {
        return (T)((Object)Objects.requireNonNull(instance, "Addon is not enabled!"));
    }

    @Nonnull
    public static AddonConfig config() {
        return ((AbstractAddon)((Object)AbstractAddon.instance())).getConfig();
    }

    public static void log(Level level, String ... messages) {
        Logger logger = AbstractAddon.instance().getLogger();
        for (String msg : messages) {
            logger.log(level, msg);
        }
    }

    public static int slimefunTickCount() {
        return ((AbstractAddon)((Object)AbstractAddon.instance())).slimefunTickCount;
    }

    @Nonnull
    public static Environment environment() {
        return ((AbstractAddon)((Object)AbstractAddon.instance())).environment;
    }

    @Nonnull
    public static NamespacedKey createKey(String s) {
        return new NamespacedKey(AbstractAddon.instance(), s);
    }
}

