/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc.infinitylib.machines;

import io.github.seggan.sfcalc.infinitylib.machines.MachineInput;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.inventory.ItemStack;

final class MachineBlockRecipe {
    private String[] strings = ArrayUtils.EMPTY_STRING_ARRAY;
    private int[] amounts = ArrayUtils.EMPTY_INT_ARRAY;
    final ItemStack output;

    void add(@Nullable ItemStack item) {
        if (item != null && !item.getType().isAir()) {
            String string = Slimefun.getItemDataService().getItemData(item).orElseGet(() -> item.getType().name());
            int len = this.strings.length;
            for (int i = 0; i < len; ++i) {
                if (!this.strings[i].equals(string)) continue;
                int n = i;
                this.amounts[n] = this.amounts[n] + item.getAmount();
                return;
            }
            String[] expanded = new String[len + 1];
            int[] expandedAmounts = new int[len + 1];
            System.arraycopy(this.strings, 0, expanded, 0, len);
            System.arraycopy(this.amounts, 0, expandedAmounts, 0, len);
            expanded[len] = string;
            expandedAmounts[len] = item.getAmount();
            this.strings = expanded;
            this.amounts = expandedAmounts;
        }
    }

    boolean check(Map<String, MachineInput> map) {
        for (int i = 0; i < this.strings.length; ++i) {
            MachineInput input = map.get(this.strings[i]);
            if (input != null && input.amount >= this.amounts[i]) continue;
            return false;
        }
        return true;
    }

    void consume(Map<String, MachineInput> map) {
        block0: for (int i = 0; i < this.strings.length; ++i) {
            int consume = this.amounts[i];
            for (ItemStack item : map.get((Object)this.strings[i]).items) {
                int amt = item.getAmount();
                if (amt >= consume) {
                    item.setAmount(amt - consume);
                    continue block0;
                }
                item.setAmount(0);
                consume -= amt;
            }
        }
    }

    public MachineBlockRecipe(ItemStack output) {
        this.output = output;
    }
}

