/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.SFCalc;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

public class Executor
implements CommandExecutor {
    private final SFCalc plugin;

    public Executor(SFCalc plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        int amount;
        if (args.length > 2 || args.length == 0) {
            return false;
        }
        String reqItem = args[0];
        if (args.length == 1) {
            amount = 1;
        } else if (PatternUtils.NUMERIC.matcher(args[1]).matches()) {
            amount = Integer.parseInt(args[1]);
        } else {
            sender.sendMessage(ChatColor.RED + "That's not a number!");
            return true;
        }
        reqItem = reqItem.toUpperCase();
        SlimefunItem item = SlimefunItem.getByID((String)reqItem);
        if (item == null) {
            sender.sendMessage(ChatColor.RED + "That item was not found.");
            return true;
        }
        List<String> result = this.calculate(item);
        HashSet<String> resultSet = new HashSet<String>(result);
        sender.sendMessage(ChatColor.YELLOW + "Recipe for " + Executor.capitalize(reqItem.replace("_", " ") + ":"));
        for (String name : resultSet) {
            sender.sendMessage(ChatColor.YELLOW + String.format("%d of %s", Collections.frequency(result, name) * amount, Executor.capitalize(name.replace("_", " ").toLowerCase())));
        }
        return true;
    }

    private List<String> calculate(SlimefunItem item) {
        ArrayList<String> result = new ArrayList<String>();
        for (ItemStack i : item.getRecipe()) {
            if (i == null) continue;
            SlimefunItem ingredient = SlimefunItem.getByItem((ItemStack)i);
            if (ingredient == null) {
                result.add(i.getType().toString());
                continue;
            }
            if (this.plugin.blacklistedIds.contains(ingredient.getID().toLowerCase())) {
                result.add(ChatColor.stripColor((String)ingredient.getItemName()));
                continue;
            }
            if (!this.plugin.blacklistedRecipes.contains(ingredient.getRecipeType())) {
                List<String> subitems = this.calculate(ingredient);
                result.addAll(subitems);
                continue;
            }
            result.add(ChatColor.stripColor((String)ingredient.getItemName()));
        }
        return result;
    }

    private static String capitalize(String s) {
        StringBuilder capped = new StringBuilder();
        String string = s.trim();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0) {
                capped.append(Character.toUpperCase(c));
                continue;
            }
            c = Character.toLowerCase(c);
            if (string.charAt(i - 1) == ' ') {
                c = Character.toUpperCase(c);
            }
            capped.append(c);
        }
        return capped.toString();
    }
}

