/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc.infinitylib.recipes;

import io.github.seggan.sfcalc.infinitylib.items.StackUtils;
import io.github.seggan.sfcalc.infinitylib.recipes.AbstractRecipe;
import javax.annotation.Nonnull;
import org.bukkit.inventory.ItemStack;

public final class ShapedRecipe
extends AbstractRecipe {
    public ShapedRecipe(ItemStack[] input) {
        super(input);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (ItemStack item : this.getRawInput()) {
            if (item != null) {
                hash += StackUtils.getIDorType(item).hashCode();
                continue;
            }
            ++hash;
        }
        return hash;
    }

    @Override
    protected boolean matches(@Nonnull AbstractRecipe input) {
        ItemStack[] inputArr = input.getRawInput();
        ItemStack[] recipeArr = this.getRawInput();
        for (int i = 0; i < inputArr.length; ++i) {
            ItemStack in = inputArr[i];
            ItemStack re = recipeArr[i];
            if (!(in == null ? re != null : re != null && (in.getAmount() < re.getAmount() || !StackUtils.getIDorType(in).equals(StackUtils.getIDorType(re))))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void consume(@Nonnull AbstractRecipe input) {
        ItemStack[] inputArr = input.getRawInput();
        ItemStack[] recipeArr = this.getRawInput();
        for (int i = 0; i < inputArr.length; ++i) {
            ItemStack in = inputArr[i];
            if (in == null) continue;
            in.setAmount(in.getAmount() - recipeArr[i].getAmount());
        }
    }
}

