/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc.infinitylib.recipes;

import io.github.seggan.sfcalc.infinitylib.recipes.AbstractRecipe;
import io.github.seggan.sfcalc.infinitylib.recipes.RecipeOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.inventory.ItemStack;

public final class RecipeMap<O> {
    private final Function<ItemStack[], ? extends AbstractRecipe> recipeConstructor;
    private final Map<AbstractRecipe, O> recipes = new ConcurrentHashMap<AbstractRecipe, O>();

    public void put(@Nonnull ItemStack[] rawInput, @Nonnull O output) {
        this.recipes.put(this.recipeConstructor.apply(rawInput), output);
    }

    @Nullable
    public RecipeOutput<O> get(@Nonnull ItemStack[] rawInput) {
        AbstractRecipe input = this.recipeConstructor.apply(rawInput);
        O output = this.recipes.get(input);
        if (output != null) {
            return new RecipeOutput<O>(output, input);
        }
        return null;
    }

    @Nullable
    public O getAndConsume(@Nonnull ItemStack[] rawInput) {
        AbstractRecipe input = this.recipeConstructor.apply(rawInput);
        O output = this.recipes.get(input);
        if (output != null) {
            input.consumeMatchingRecipe();
            return output;
        }
        return null;
    }

    @Nullable
    public O getNoConsume(@Nonnull ItemStack[] rawInput) {
        return this.recipes.get(this.recipeConstructor.apply(rawInput));
    }

    public RecipeMap(Function<ItemStack[], ? extends AbstractRecipe> recipeConstructor) {
        this.recipeConstructor = recipeConstructor;
    }
}

