/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc.infinitylib;

import io.github.seggan.sfcalc.infinitylib.bstats.bukkit.Metrics;
import io.github.seggan.sfcalc.infinitylib.bstats.charts.SimplePie;
import io.github.seggan.sfcalc.infinitylib.commands.AbstractCommand;
import io.github.seggan.sfcalc.infinitylib.commands.CommandUtils;
import io.github.seggan.sfcalc.infinitylib.configuration.AddonConfig;
import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public abstract class AbstractAddon
extends JavaPlugin
implements SlimefunAddon {
    private String bugTrackerURL;
    private AddonConfig config;
    private int globalTick;

    public AbstractAddon() {
    }

    @ParametersAreNonnullByDefault
    public AbstractAddon(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
    }

    public final void onEnable() {
        String userSlashRepo = this.getGithubPath().substring(0, this.getGithubPath().lastIndexOf(47));
        this.bugTrackerURL = "https://github.com/" + userSlashRepo + "/issues";
        this.config = new AddonConfig(this, "config.yml");
        if (SlimefunPlugin.getMinecraftVersion() != MinecraftVersion.UNIT_TEST) {
            this.autoUpdateAndMetrics();
        }
        this.scheduleRepeatingSync(() -> ++this.globalTick, SlimefunPlugin.getTickerTask().getTickRate());
        List<AbstractCommand> subCommands = this.setupSubCommands();
        if (subCommands != null) {
            CommandUtils.addSubCommands(this, this.getCommandName(), subCommands);
        }
        try {
            this.enable();
        }
        catch (Throwable e) {
            this.runSync(() -> {
                this.log(Level.SEVERE, "#################################################################", "The following error has occurred during " + this.getName() + "'s startup!", "Not all items and features will be available because of this!", "Report this on Github or Discord and make sure to update Slimefun!");
                e.printStackTrace();
                this.log(Level.SEVERE, "#################################################################");
            });
        }
    }

    private void autoUpdateAndMetrics() {
        Metrics metrics;
        Boolean autoUpdate = null;
        if (this.getAutoUpdatePath() != null && this.getDescription().getVersion().startsWith("DEV - ")) {
            autoUpdate = this.config.getBoolean(this.getAutoUpdatePath());
            if (autoUpdate.booleanValue()) {
                new GitHubBuildsUpdater((Plugin)this, this.getFile(), this.getGithubPath()).start();
            } else {
                this.runSync(() -> this.log("#######################################", "Auto Updates have been disabled for " + this.getName(), "You will receive no support for bugs", "Until you update to the latest version!", "#######################################"));
            }
        }
        if ((metrics = this.setupMetrics()) != null && autoUpdate != null) {
            String autoUpdates = autoUpdate.toString();
            metrics.addCustomChart(new SimplePie("auto_updates", () -> autoUpdates));
        }
    }

    public final void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.disable();
    }

    protected abstract void enable();

    protected abstract void disable();

    @Nonnull
    protected abstract String getGithubPath();

    @Nullable
    protected Metrics setupMetrics() {
        return null;
    }

    @Nullable
    protected List<AbstractCommand> setupSubCommands() {
        return null;
    }

    @Nonnull
    protected String getCommandName() {
        return this.getName();
    }

    @Nullable
    public abstract String getAutoUpdatePath();

    public final int getGlobalTick() {
        return this.globalTick;
    }

    @Nonnull
    public final JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nonnull
    public final String getBugTrackerURL() {
        return this.bugTrackerURL;
    }

    @Nonnull
    public final AddonConfig getConfig() {
        return this.config;
    }

    public final void reloadConfig() {
        this.config.reload();
    }

    public final void saveConfig() {
        this.config.save();
    }

    public final void saveDefaultConfig() {
    }

    public final NamespacedKey getKey(String s) {
        return new NamespacedKey((Plugin)this, s);
    }

    public final void log(String ... messages) {
        this.log(Level.INFO, messages);
    }

    public final void log(Level level, String ... messages) {
        if (SlimefunPlugin.getMinecraftVersion() != MinecraftVersion.UNIT_TEST) {
            Logger logger = this.getLogger();
            for (String msg : messages) {
                logger.log(level, msg);
            }
        }
    }

    public final void registerListener(Listener ... listeners) {
        PluginManager manager = Bukkit.getPluginManager();
        for (Listener listener : listeners) {
            manager.registerEvents(listener, (Plugin)this);
        }
    }

    public final void runSync(Runnable runnable) {
        Bukkit.getScheduler().runTask((Plugin)this, runnable);
    }

    public final void runSync(Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLater((Plugin)this, runnable, delay);
    }

    public final void scheduleRepeatingSync(Runnable runnable, long interval) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, runnable, 0L, interval);
    }

    public final void scheduleRepeatingSync(Runnable runnable, long delay, long interval) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, runnable, delay, interval);
    }

    public final void runAsync(Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, runnable);
    }

    public final void runAsync(Runnable runnable, long delay) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, runnable, delay);
    }

    public final void scheduleRepeatingAsync(Runnable runnable, long interval) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, runnable, 0L, interval);
    }

    public final void scheduleRepeatingAsync(Runnable runnable, long delay, long interval) {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, runnable, delay, interval);
    }
}

