/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc.infinitylib.slimefun.utils;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.categories.FlexCategory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.guide.SurvivalSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class MultiCategory
extends FlexCategory {
    public static final SurvivalSlimefunGuide SURVIVAL_GUIDE = (SurvivalSlimefunGuide)SlimefunPlugin.getRegistry().getSlimefunGuide(SlimefunGuideMode.SURVIVAL_MODE);
    private final Category[] subCategories;

    public MultiCategory(NamespacedKey key, ItemStack item, Category ... subCategories) {
        this(key, item, 3, subCategories);
    }

    public MultiCategory(NamespacedKey key, ItemStack item, int tier, Category ... subCategories) {
        super(key, item, tier);
        this.subCategories = subCategories;
    }

    public boolean isVisible(@Nonnull Player p, @Nonnull PlayerProfile profile, @Nonnull SlimefunGuideMode mode) {
        return true;
    }

    public void open(Player p, PlayerProfile profile, SlimefunGuideMode mode) {
        this.openGuide(p, profile, mode, 1);
    }

    private void openGuide(Player p, PlayerProfile profile, SlimefunGuideMode mode, int page) {
        profile.getGuideHistory().add((Category)this, page);
        ChestMenu menu = new ChestMenu(SlimefunPlugin.getLocalization().getMessage(p, "guide.title.main"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), SURVIVAL_GUIDE.getSound(), 1.0f, 1.0f));
        SURVIVAL_GUIDE.createHeader(p, profile, menu);
        menu.addItem(1, (ItemStack)new CustomItem(ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", ChatColor.GRAY + SlimefunPlugin.getLocalization().getMessage(p, "guide.back.guide")})));
        menu.addMenuClickHandler(1, (pl, s, is, action) -> {
            profile.getGuideHistory().goBack((SlimefunGuideImplementation)SURVIVAL_GUIDE);
            return false;
        });
        int target = 36 * (page - 1) - 1;
        for (int index = 9; target < this.subCategories.length - 1 && index < 45; ++index) {
            Category category = this.subCategories[++target];
            menu.addItem(index, category.getItem(p));
            menu.addMenuClickHandler(index, (pl, slot, item, action) -> {
                SlimefunGuide.openCategory((PlayerProfile)profile, (Category)category, (SlimefunGuideMode)mode, (int)1);
                return false;
            });
        }
        int pages = target == this.subCategories.length - 1 ? page : (this.subCategories.length - 1) / 36 + 1;
        menu.addItem(46, ChestMenuUtils.getPreviousButton((Player)p, (int)page, (int)pages));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            int next = page - 1;
            if (next > 0) {
                this.openGuide(p, profile, mode, next);
            }
            return false;
        });
        menu.addItem(52, ChestMenuUtils.getNextButton((Player)p, (int)page, (int)pages));
        menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
            int next = page + 1;
            if (next <= pages) {
                this.openGuide(p, profile, mode, next);
            }
            return false;
        });
        menu.open(new Player[]{p});
    }

    public void register(@Nonnull SlimefunAddon addon) {
        super.register(addon);
        for (Category category : this.subCategories) {
            category.register(addon);
        }
    }
}

