/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.SFCalc;
import io.github.seggan.sfcalc.SFCalcMetrics;
import io.github.seggan.sfcalc.StringRegistry;
import io.github.seggan.sfcalc.infinitylib.commands.AbstractCommand;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class NeededCommand
extends AbstractCommand {
    private static final List<String> ids = new ArrayList<String>();
    private final SFCalc plugin;

    public NeededCommand(SFCalc pl) {
        super("needed", "Tells you how much more resources are needed", false);
        this.plugin = pl;
    }

    @Override
    protected void onExecute(@Nonnull CommandSender sender, @Nonnull String[] args) {
        long amount;
        StringRegistry registry = this.plugin.getStringRegistry();
        if (!(sender instanceof Player)) {
            sender.sendMessage(StringRegistry.format(registry.getNotAPlayerString(), new Object[0]));
            return;
        }
        if (args.length > 3 || args.length < 2) {
            return;
        }
        String reqItem = args[1];
        if (args.length == 2) {
            amount = 1L;
        } else {
            if (!PatternUtils.NUMERIC.matcher(args[2]).matches()) {
                sender.sendMessage(StringRegistry.format(registry.getNotANumberString(), new Object[0]));
                return;
            }
            try {
                amount = Long.parseLong(args[2]);
                if (amount == 0L || amount > Integer.MAX_VALUE) {
                    sender.sendMessage(StringRegistry.format(registry.getInvalidNumberString(), new Object[0]));
                    return;
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage(StringRegistry.format(registry.getInvalidNumberString(), new Object[0]));
                return;
            }
        }
        SlimefunItem item = SlimefunItem.getByID((String)reqItem.toUpperCase());
        if (item == null) {
            sender.sendMessage(StringRegistry.format(registry.getNoItemString(), new Object[0]));
            return;
        }
        SFCalcMetrics.addItemSearched(item.getItemName());
        this.plugin.getCalc().printResults(sender, item, amount, true);
    }

    @Override
    protected void onTab(@Nonnull CommandSender sender, @Nonnull String[] args, @Nonnull List<String> tabs) {
        if (ids.isEmpty()) {
            for (SlimefunItem item : SlimefunPlugin.getRegistry().getEnabledSlimefunItems()) {
                ids.add(item.getId().toLowerCase(Locale.ROOT));
            }
        }
        if (args.length == 2) {
            StringUtil.copyPartialMatches((String)args[1], ids, tabs);
        }
    }
}

