/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.SFCalc;
import io.github.seggan.sfcalc.StringRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Calculator {
    private SFCalc plugin;

    public Calculator(SFCalc pl) {
        this.plugin = pl;
    }

    public void printResults(@Nonnull CommandSender sender, @Nonnull SlimefunItem item, long amount, boolean needed) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Map<ItemStack, Long> results = this.calculate(item, amount);
            StringRegistry registry = this.plugin.getStringRegistry();
            String name = this.getBasicName(item.getItem());
            String header = amount == 1L ? StringRegistry.format(registry.getHeaderString(), name) : StringRegistry.format(registry.getHeaderAmountString(), name, amount);
            sender.sendMessage(header);
            ArrayList<Map.Entry<ItemStack, Long>> entries = new ArrayList<Map.Entry<ItemStack, Long>>(results.entrySet());
            entries.sort(Comparator.comparingLong(Map.Entry::getValue));
            if (needed && sender instanceof Player) {
                Map<ItemStack, Long> inv = this.getInventoryAsItemList((Player)sender);
                for (Map.Entry entry : entries) {
                    int maxStackSize;
                    long inInventory = inv.getOrDefault(entry.getKey(), 0L);
                    if ((Long)entry.getValue() <= 0L) continue;
                    long a = (Long)entry.getValue() - inInventory;
                    if (a < 0L) {
                        a = 0L;
                    }
                    String parsedAmount = a <= (long)(maxStackSize = ((ItemStack)entry.getKey()).getMaxStackSize()) ? Long.toString(a) : StringRegistry.format(registry.getStackString(), a, (long)Math.floor((double)a / (double)maxStackSize), maxStackSize, a % (long)maxStackSize);
                    sender.sendMessage(StringRegistry.format(registry.getNeededString(), this.getBasicName((ItemStack)entry.getKey()), parsedAmount));
                }
            } else {
                for (Map.Entry entry : entries) {
                    long l = (Long)entry.getValue();
                    if (l <= 0L) continue;
                    int maxStackSize = ((ItemStack)entry.getKey()).getMaxStackSize();
                    String parsedAmount = l <= (long)maxStackSize ? Long.toString(l) : StringRegistry.format(registry.getStackString(), l, (long)Math.floor((float)l / (float)maxStackSize), maxStackSize, l % (long)maxStackSize);
                    sender.sendMessage(StringRegistry.format(registry.getAmountString(), this.getBasicName((ItemStack)entry.getKey()), parsedAmount));
                }
            }
        });
    }

    @Nonnull
    private Map<ItemStack, Long> getInventoryAsItemList(@Nonnull Player player) {
        HashMap<ItemStack, Long> inv = new HashMap<ItemStack, Long>();
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType().isAir()) continue;
            this.add(inv, item, item.getAmount());
        }
        return inv;
    }

    @Nonnull
    public Map<ItemStack, Long> calculate(@Nonnull SlimefunItem parent, long amount) {
        HashMap<ItemStack, Long> result = new HashMap<ItemStack, Long>();
        this.add(result, parent.getItem(), amount);
        this.add(result, parent.getItem(), -parent.getRecipeOutput().getAmount());
        for (ItemStack item : parent.getRecipe()) {
            if (item == null) continue;
            this.add(result, item, item.getAmount());
        }
        SlimefunItemStack next = this.getNextItem(result);
        while (next != null) {
            int multiplier = next.getItem().getRecipeOutput().getAmount();
            long operations = ((Long)result.get(next) + (long)multiplier - 1L) / (long)multiplier;
            this.add(result, (ItemStack)next, -((long)multiplier * operations));
            for (ItemStack item : next.getItem().getRecipe()) {
                if (item == null) continue;
                this.add(result, item, (long)item.getAmount() * operations);
            }
            next = this.getNextItem(result);
        }
        return result;
    }

    @Nullable
    private SlimefunItemStack getNextItem(Map<ItemStack, Long> map) {
        for (Map.Entry<ItemStack, Long> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof SlimefunItemStack)) continue;
            SlimefunItemStack ingredient = (SlimefunItemStack)entry.getKey();
            if (this.plugin.getBlacklistedIds().contains(ingredient.getItemId()) || this.plugin.getBlacklistedRecipes().contains(ingredient.getItem().getRecipeType()) || entry.getValue() <= 0L) continue;
            return ingredient;
        }
        return null;
    }

    private void add(@Nonnull Map<ItemStack, Long> map, @Nonnull ItemStack key, long amount) {
        ItemStack clone = key.clone();
        clone.setAmount(1);
        map.merge(clone, amount, Long::sum);
    }

    private void addAll(@Nonnull Map<ItemStack, Long> map, @Nonnull Map<ItemStack, Long> otherMap, long multiplier) {
        for (Map.Entry<ItemStack, Long> entry : otherMap.entrySet()) {
            this.add(map, entry.getKey(), entry.getValue() * multiplier);
        }
    }

    @Nonnull
    private String getBasicName(ItemStack stack) {
        return ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)stack));
    }
}

