/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.SFCalc;
import io.github.seggan.sfcalc.StringRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Calculator {
    private final Set<RecipeType> blacklistedRecipes;
    private final Set<String> blacklistedIds;

    public void printResults(@Nonnull CommandSender sender, @Nonnull SlimefunItem item, long amount, boolean needed) {
        Map<ItemStack, Long> results = this.calculate(item);
        StringRegistry registry = SFCalc.inst().getStringRegistry();
        String name = Calculator.getBasicName(item.getItem());
        String header = amount == 1L ? StringRegistry.format(registry.getHeaderString(), name) : StringRegistry.format(registry.getHeaderAmountString(), name, amount);
        sender.sendMessage(header);
        ArrayList<Map.Entry<ItemStack, Long>> entries = new ArrayList<Map.Entry<ItemStack, Long>>(results.entrySet());
        entries.sort(Comparator.comparingLong(Map.Entry::getValue));
        if (needed && sender instanceof Player) {
            Map<ItemStack, Long> inv = this.getInventoryAsItemList((Player)sender);
            for (Map.Entry entry : entries) {
                int maxStackSize;
                Long inInventory = inv.getOrDefault(entry.getKey(), 0L);
                long a = (Long)entry.getValue() * amount - inInventory;
                String parsedAmount = a <= (long)(maxStackSize = ((ItemStack)entry.getKey()).getMaxStackSize()) ? Long.toString(a) : StringRegistry.format(registry.getStackString(), a, (long)Math.floor((double)a / (double)maxStackSize), maxStackSize, a % (long)maxStackSize);
                sender.sendMessage(StringRegistry.format(registry.getNeededString(), Calculator.getBasicName((ItemStack)entry.getKey()), parsedAmount));
            }
        } else {
            for (Map.Entry entry : entries) {
                int maxStackSize;
                long l = (Long)entry.getValue() * amount;
                String parsedAmount = l <= (long)(maxStackSize = ((ItemStack)entry.getKey()).getMaxStackSize()) ? Long.toString(l) : StringRegistry.format(registry.getStackString(), l, (long)Math.floor((float)l / (float)maxStackSize), maxStackSize, l % (long)maxStackSize);
                sender.sendMessage(StringRegistry.format(registry.getAmountString(), Calculator.getBasicName((ItemStack)entry.getKey()), parsedAmount));
            }
        }
    }

    @Nonnull
    private Map<ItemStack, Long> getInventoryAsItemList(@Nonnull Player player) {
        HashMap<ItemStack, Long> inv = new HashMap<ItemStack, Long>();
        for (ItemStack item : player.getInventory().getContents()) {
            if (item.getType().isAir()) continue;
            this.add(inv, item, item.getAmount());
        }
        return inv;
    }

    @Nonnull
    public Map<ItemStack, Long> calculate(@Nonnull SlimefunItem item) {
        HashMap<ItemStack, Long> result = new HashMap<ItemStack, Long>();
        HashMap<ItemStack, HashMap<ItemStack, Long>> calculated = new HashMap<ItemStack, HashMap<ItemStack, Long>>();
        for (ItemStack i : item.getRecipe()) {
            if (i == null) continue;
            int amount = i.getAmount();
            if (calculated.containsKey(i)) {
                this.addAll(result, (Map)calculated.get(i), amount);
                continue;
            }
            HashMap<ItemStack, Long> recipe = new HashMap<ItemStack, Long>();
            SlimefunItem ingredient = SlimefunItem.getByItem((ItemStack)i);
            if (ingredient == null) {
                this.add(recipe, i, 1L);
            } else {
                if (ingredient.getRecipeType().getKey().getKey().toLowerCase(Locale.ROOT).equals("metal_forge")) {
                    this.add(recipe, new ItemStack(Material.DIAMOND), 9L);
                    continue;
                }
                if (this.blacklistedIds.contains(ingredient.getId())) {
                    this.add(recipe, i, 1L);
                } else if (this.blacklistedRecipes.contains(ingredient.getRecipeType())) {
                    this.add(recipe, i, 1L);
                } else {
                    this.addAll(recipe, this.calculate(ingredient), 1L);
                }
            }
            calculated.put(i, recipe);
            this.addAll(result, recipe, amount);
        }
        return result;
    }

    private void add(@Nonnull Map<ItemStack, Long> map, @Nonnull ItemStack key, long amount) {
        map.merge(key, amount, Long::sum);
    }

    private void addAll(@Nonnull Map<ItemStack, Long> map, @Nonnull Map<ItemStack, Long> otherMap, long multiplier) {
        for (Map.Entry<ItemStack, Long> entry : otherMap.entrySet()) {
            this.add(map, entry.getKey(), entry.getValue() * multiplier);
        }
    }

    @Nonnull
    private static String getBasicName(ItemStack stack) {
        return ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)stack));
    }

    public Calculator(Set<RecipeType> blacklistedRecipes, Set<String> blacklistedIds) {
        this.blacklistedRecipes = blacklistedRecipes;
        this.blacklistedIds = blacklistedIds;
    }
}

