/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc.infinitylib.recipes.largestrict;

import io.github.seggan.sfcalc.infinitylib.items.StackUtils;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.inventory.ItemStack;

final class StrictLargeRecipe {
    private final String string;
    final int[] amounts;

    StrictLargeRecipe(ItemStack[] recipe, int[] amounts) {
        StringBuilder builder = new StringBuilder();
        for (ItemStack item : recipe) {
            if (item != null) {
                builder.append(StackUtils.getIDorType(item));
            }
            builder.append(';');
        }
        this.string = builder.toString();
        this.amounts = amounts;
    }

    StrictLargeRecipe(ItemStack[] recipe) {
        StringBuilder builder = new StringBuilder();
        int[] amounts = new int[recipe.length];
        for (int i = 0; i < recipe.length; ++i) {
            ItemStack item = recipe[i];
            if (item != null) {
                builder.append(StackUtils.getIDorType(item));
                amounts[i] = item.getAmount();
            }
            builder.append(';');
        }
        this.string = builder.toString();
        this.amounts = amounts;
    }

    StrictLargeRecipe(BlockMenu menu, int[] slots) {
        StringBuilder builder = new StringBuilder();
        int[] amounts = new int[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            ItemStack item = menu.getItemInSlot(slots[i]);
            if (item != null) {
                builder.append(StackUtils.getIDorType(item));
                amounts[i] = item.getAmount();
            }
            builder.append(';');
        }
        this.string = builder.toString();
        this.amounts = amounts;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StrictLargeRecipe)) {
            return false;
        }
        StrictLargeRecipe recipe = (StrictLargeRecipe)obj;
        for (int i = 0; i < this.amounts.length; ++i) {
            if (recipe.amounts[i] <= this.amounts[i]) continue;
            return false;
        }
        return recipe.string.equals(this.string);
    }
}

