/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.Calculator;
import io.github.seggan.sfcalc.SFCalc;
import io.github.seggan.sfcalc.SFCalcMetrics;
import io.github.seggan.sfcalc.StringRegistry;
import io.github.seggan.sfcalc.infinitylib.commands.AbstractCommand;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class NeededCommand
extends AbstractCommand {
    private static final List<String> ids = new ArrayList<String>();

    public NeededCommand() {
        super("needed", "Tells you how much more resources are needed", false);
    }

    @Override
    protected void onExecute(@Nonnull CommandSender sender, @Nonnull String[] args) {
        long amount;
        StringRegistry registry = SFCalc.inst().getStringRegistry();
        if (!(sender instanceof Player)) {
            sender.sendMessage(registry.getNotAPlayerString());
            return;
        }
        if (args.length > 3) {
            return;
        }
        String reqItem = args[1];
        if (args.length == 2) {
            amount = 1L;
        } else {
            if (!PatternUtils.NUMERIC.matcher(args[2]).matches()) {
                sender.sendMessage(registry.getNotANumberString());
                return;
            }
            try {
                amount = Long.parseLong(args[2]);
                if (amount == 0L || amount > Integer.MAX_VALUE) {
                    sender.sendMessage(registry.getInvalidNumberString());
                    return;
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage(registry.getInvalidNumberString());
                return;
            }
        }
        SlimefunItem item = SlimefunItem.getByID((String)reqItem.toUpperCase());
        if (item == null) {
            sender.sendMessage(registry.getNoItemString());
            return;
        }
        SFCalcMetrics.addItemSearched(item.getItemName());
        Calculator calculator = new Calculator(SFCalc.inst());
        calculator.printResults(sender, item, amount, true);
    }

    @Override
    protected void onTab(@Nonnull CommandSender sender, @Nonnull String[] args, @Nonnull List<String> tabs) {
        if (ids.isEmpty()) {
            for (SlimefunItem item : SlimefunPlugin.getRegistry().getEnabledSlimefunItems()) {
                ids.add(item.getId().toLowerCase(Locale.ROOT));
            }
        }
        if (args.length == 2) {
            StringUtil.copyPartialMatches((String)args[1], ids, tabs);
        }
    }
}

