/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.SFCalc;
import io.github.seggan.sfcalc.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import org.apache.commons.lang.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Calculator {
    private final SFCalc plugin;

    public Calculator(SFCalc plugin) {
        this.plugin = plugin;
    }

    public void printResults(CommandSender sender, String command, SlimefunItem item, long amount) {
        Map<String, Long> results = this.calculate(item);
        String name = ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)item.getItem()));
        String header = amount == 1L ? String.format(this.plugin.headerString, name) : Util.format(this.plugin.headerAmountString, amount, name);
        sender.sendMessage(header);
        ArrayList<Map.Entry<String, Long>> entries = new ArrayList<Map.Entry<String, Long>>(results.entrySet());
        entries.sort(Comparator.comparingLong(Map.Entry::getValue));
        if (command.equals("sfneeded") && sender instanceof Player) {
            Map<String, Long> inv = this.getInventoryAsItemList((Player)sender);
            for (Map.Entry entry : entries) {
                Long inInventory = inv.getOrDefault(entry.getKey(), 0L);
                sender.sendMessage(Util.format(this.plugin.neededString, (Long)entry.getValue() * amount - inInventory, WordUtils.capitalizeFully((String)((String)entry.getKey()))));
            }
        } else {
            for (Map.Entry entry : entries) {
                sender.sendMessage(Util.format(this.plugin.amountString, (Long)entry.getValue() * amount, WordUtils.capitalizeFully((String)((String)entry.getKey()))));
            }
        }
    }

    private Map<String, Long> getInventoryAsItemList(Player player) {
        HashMap<String, Long> inv = new HashMap<String, Long>();
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null) continue;
            this.add(inv, ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)item)), item.getAmount());
        }
        return inv;
    }

    private Map<String, Long> calculate(SlimefunItem item) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        HashMap<String, HashMap<String, Long>> calculated = new HashMap<String, HashMap<String, Long>>();
        for (ItemStack i : item.getRecipe()) {
            if (i == null) continue;
            String name = ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)i));
            int amount = i.getAmount();
            if (calculated.containsKey(name)) {
                this.addAll(result, (Map)calculated.get(name), amount);
                continue;
            }
            HashMap<String, Long> recipe = new HashMap<String, Long>();
            SlimefunItem ingredient = SlimefunItem.getByItem((ItemStack)i);
            if (ingredient == null) {
                this.add(recipe, name, 1L);
            } else {
                if (ingredient.getRecipeType().getKey().getKey().equals("metal_forge")) {
                    this.add(recipe, "diamond", 9L);
                }
                if (this.plugin.blacklistedIds.contains(ingredient.getId().toLowerCase(Locale.ROOT))) {
                    this.add(recipe, name, 1L);
                } else if (!this.plugin.blacklistedRecipes.contains(ingredient.getRecipeType())) {
                    this.addAll(recipe, this.calculate(ingredient), 1L);
                } else {
                    this.add(recipe, name, 1L);
                }
            }
            calculated.put(name, recipe);
            this.addAll(result, recipe, amount);
        }
        return result;
    }

    private void add(Map<String, Long> map, String key, long amount) {
        map.merge(key.toLowerCase(), amount, Long::sum);
    }

    private void addAll(Map<String, Long> map, Map<String, Long> otherMap, long multiplier) {
        for (Map.Entry<String, Long> entry : otherMap.entrySet()) {
            this.add(map, entry.getKey(), entry.getValue() * multiplier);
        }
    }
}

