/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.CalcCompleter;
import io.github.seggan.sfcalc.CalcExecutor;
import io.github.seggan.sfcalc.CalcHandler;
import io.github.seggan.sfcalc.SFCalcMetrics;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SFCalc
extends JavaPlugin
implements SlimefunAddon {
    private static SFCalc instance;
    protected final Set<RecipeType> blacklistedRecipes = new HashSet<RecipeType>();
    protected final Set<String> blacklistedIds = new HashSet<String>();
    protected final List<String> itemsSearched = new ArrayList<String>();
    protected String headerString;
    protected String headerAmountString;
    protected String amountString;
    protected String neededString;
    protected String noItemString;
    protected String noNumberString;
    protected String tooManyCategoriesString;
    protected String tooManyItemsString;
    protected String notAPlayerString;
    protected String invalidNumberString;

    public void onEnable() {
        this.getLogger().info("SFCalc enabled.");
        this.saveDefaultConfig();
        new SFCalcMetrics(this);
        if (this.getConfig().getBoolean("options.auto-update") && this.getDescription().getVersion().startsWith("DEV - ")) {
            new GitHubBuildsUpdater((Plugin)this, this.getFile(), "Seggan/SFCalc/master").start();
        }
        this.loadStrings();
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)new CalcHandler(), (Plugin)this);
        this.blacklistedRecipes.add(RecipeType.ORE_WASHER);
        this.blacklistedRecipes.add(RecipeType.GEO_MINER);
        this.blacklistedRecipes.add(RecipeType.GOLD_PAN);
        this.blacklistedRecipes.add(RecipeType.MOB_DROP);
        this.blacklistedRecipes.add(RecipeType.BARTER_DROP);
        this.blacklistedRecipes.add(RecipeType.ORE_CRUSHER);
        this.blacklistedRecipes.add(RecipeType.NULL);
        this.blacklistedIds.add("uu_matter");
        this.blacklistedIds.add("silicon");
        instance = this;
    }

    private void registerCommands() {
        CalcExecutor executor = new CalcExecutor(this);
        CalcCompleter completer = new CalcCompleter();
        Objects.requireNonNull(this.getCommand("sfcalc")).setExecutor((CommandExecutor)executor);
        Objects.requireNonNull(this.getCommand("sfcalc")).setTabCompleter((TabCompleter)completer);
        Objects.requireNonNull(this.getCommand("sfneeded")).setExecutor((CommandExecutor)executor);
        Objects.requireNonNull(this.getCommand("sfneeded")).setTabCompleter((TabCompleter)completer);
    }

    public void onDisable() {
        this.getLogger().info("SFCalc disabled.");
    }

    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public String getBugTrackerURL() {
        return "https://github.com/Seggan/SFCalc/issues";
    }

    static SFCalc getInstance() {
        return instance;
    }

    private void loadStrings() {
        this.headerString = this.loadString("header-string", "&e&nRecipe for %s:");
        this.headerAmountString = this.loadString("header-amount-string", "&e&nRecipe for %d %s:");
        this.amountString = this.loadString("amount-string", "&e%d of %s");
        this.neededString = this.loadString("needed-string", "&e%d more %s needed");
        this.noItemString = this.loadString("no-item-string", "&cThat item was not found.");
        this.noNumberString = this.loadString("no-number-string", "&cThat's not a number!");
        this.tooManyCategoriesString = this.loadString("category-error-string", "&cThat many categories is not supported yet. Please use the command form of the calculator.");
        this.tooManyItemsString = this.loadString("item-error-string", "&cThat many items is not supported yet. Please use the command form of the calculator.");
        this.notAPlayerString = this.loadString("not-a-player-string", "&cYou must be a player to send this message!");
        this.invalidNumberString = this.loadString("invalid-number-string", "&cInvalid number!");
    }

    private String loadString(String path, String defaultValue) {
        String value = this.getConfig().getString(path);
        if (value != null) {
            return ChatColors.color((String)value);
        }
        return ChatColors.color((String)defaultValue);
    }
}

