/*
 * Decompiled with CFR 0.152.
 */
package io.github.seggan.sfcalc;

import io.github.seggan.sfcalc.SFCalc;
import io.github.seggan.sfcalc.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Calculator {
    private final SFCalc plugin;

    public Calculator(SFCalc plugin) {
        this.plugin = plugin;
    }

    public void printResults(CommandSender sender, String command, SlimefunItem item, long amount) {
        Map<String, Long> results = this.calculate(item);
        sender.sendMessage(String.format(this.plugin.headerString, ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)item.getItem()))));
        ArrayList<Map.Entry<String, Long>> entries = new ArrayList<Map.Entry<String, Long>>(results.entrySet());
        Collections.sort(entries, Comparator.comparingLong(Map.Entry::getValue));
        if (command.equals("sfneeded") && sender instanceof Player) {
            List<String> sfInv = this.getInventoryAsItemList((Player)sender);
            for (Map.Entry entry : entries) {
                int inInventory = Collections.frequency(sfInv, entry.getKey());
                sender.sendMessage(Util.format(this.plugin.neededString, (Long)entry.getValue() * amount - (long)inInventory, Util.capitalize((String)entry.getKey())));
            }
        } else {
            for (Map.Entry entry : entries) {
                sender.sendMessage(Util.format(this.plugin.amountString, (Long)entry.getValue() * amount, Util.capitalize((String)entry.getKey())));
            }
        }
    }

    private List<String> getInventoryAsItemList(Player player) {
        ArrayList<String> list = new ArrayList<String>();
        for (ItemStack item : player.getInventory().getContents()) {
            SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
            if (sfItem == null) continue;
            for (int n = 0; n < item.getAmount(); ++n) {
                list.add(ChatColor.stripColor((String)sfItem.getItemName()));
            }
        }
        return list;
    }

    private Map<String, Long> calculate(SlimefunItem item) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        switch (item.getId().toLowerCase(Locale.ROOT)) {
            case "carbon": {
                this.add(result, "coal", 8L);
                break;
            }
            case "compressed_carbon": {
                this.addAll(result, this.calculate(SlimefunItem.getByID((String)"CARBON")), 4L);
                break;
            }
            case "reinforced_plate": {
                this.addAll(result, this.calculate(SlimefunItem.getByID((String)"REINFORCED_ALLOY_INGOT")), 8L);
                break;
            }
            case "steel_plate": {
                this.addAll(result, this.calculate(SlimefunItem.getByID((String)"STEEL_INGOT")), 8L);
                break;
            }
            default: {
                for (ItemStack i : item.getRecipe()) {
                    if (i == null) continue;
                    SlimefunItem ingredient = SlimefunItem.getByItem((ItemStack)i);
                    if (ingredient == null) {
                        this.add(result, ItemUtils.getItemName((ItemStack)i));
                        continue;
                    }
                    if (ingredient.getRecipeType().getKey().getKey().equals("metal_forge")) {
                        this.add(result, "diamond", 9L);
                    }
                    if (this.plugin.blacklistedIds.contains(ingredient.getId().toLowerCase(Locale.ROOT))) {
                        this.add(result, ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)i)));
                        continue;
                    }
                    if (!this.plugin.blacklistedRecipes.contains(ingredient.getRecipeType())) {
                        this.addAll(result, this.calculate(ingredient));
                        continue;
                    }
                    this.add(result, ChatColor.stripColor((String)ItemUtils.getItemName((ItemStack)i)));
                }
            }
        }
        return result;
    }

    private void add(Map<String, Long> map, String key) {
        this.add(map, key, 1L);
    }

    private void add(Map<String, Long> map, String key, long amount) {
        map.merge(key, amount, Long::sum);
    }

    private void addAll(Map<String, Long> map, Map<String, Long> otherMap) {
        for (Map.Entry<String, Long> entry : otherMap.entrySet()) {
            this.add(map, entry.getKey(), entry.getValue());
        }
    }

    private void addAll(Map<String, Long> map, Map<String, Long> otherMap, long multiplier) {
        for (Map.Entry<String, Long> entry : otherMap.entrySet()) {
            this.add(map, entry.getKey(), entry.getValue() * multiplier);
        }
    }
}

